/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models.baker;

import forestry.arboriculture.models.ModelLeaves;
import forestry.core.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakerModel
implements BakedModel {
    private boolean isGui3d;
    private boolean isAmbientOcclusion;
    private TextureAtlasSprite particleSprite;
    @Nullable
    private ModelState modelState;
    private final Map<Direction, List<BakedQuad>> faceQuads;
    private final List<BakedQuad> generalQuads;
    private final List<Pair<BlockState, BakedModel>> models;
    private final List<Pair<BlockState, BakedModel>> modelsPost;
    private float[] rotation = ModelBakerModel.getDefaultRotation();
    private float[] translation = ModelBakerModel.getDefaultTranslation();
    private float[] scale = ModelBakerModel.getDefaultScale();

    ModelBakerModel(ModelState modelState) {
        this.models = new ArrayList<Pair<BlockState, BakedModel>>();
        this.modelsPost = new ArrayList<Pair<BlockState, BakedModel>>();
        this.faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        this.generalQuads = new ArrayList<BakedQuad>();
        this.particleSprite = ResourceUtil.getMissingTexture();
        this.isGui3d = true;
        this.isAmbientOcclusion = false;
        this.setModelState(modelState);
        for (Direction face : Direction.f_122346_) {
            this.faceQuads.put(face, new ArrayList());
        }
    }

    private ModelBakerModel(ModelBakerModel old) {
        this.models = new ArrayList<Pair<BlockState, BakedModel>>(old.models);
        this.modelsPost = new ArrayList<Pair<BlockState, BakedModel>>(old.modelsPost);
        this.faceQuads = new EnumMap<Direction, List<BakedQuad>>(old.faceQuads);
        this.generalQuads = new ArrayList<BakedQuad>(old.generalQuads);
        this.isGui3d = old.isGui3d;
        this.isAmbientOcclusion = old.isAmbientOcclusion;
        this.rotation = Arrays.copyOf(old.rotation, 3);
        this.translation = Arrays.copyOf(old.translation, 3);
        this.scale = Arrays.copyOf(old.scale, 3);
        this.particleSprite = old.particleSprite;
        this.setModelState(old.modelState);
    }

    public boolean m_7539_() {
        return this.isGui3d;
    }

    public boolean m_7547_() {
        return true;
    }

    public void setAmbientOcclusion(boolean ambientOcclusion) {
        this.isAmbientOcclusion = ambientOcclusion;
    }

    public boolean m_7541_() {
        return this.isAmbientOcclusion;
    }

    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.particleSprite = particleSprite;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particleSprite;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemTransforms m_7442_() {
        return ModelLeaves.TRANSFORMS;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private static float[] getDefaultRotation() {
        return new float[]{-80.0f, -45.0f, 170.0f};
    }

    private static float[] getDefaultTranslation() {
        return new float[]{0.0f, 1.5f, -2.75f};
    }

    private static float[] getDefaultScale() {
        return new float[]{0.375f, 0.375f, 0.375f};
    }

    public void setRotation(float[] rotation) {
        this.rotation = rotation;
    }

    public void setTranslation(float[] translation) {
        this.translation = translation;
    }

    public void setScale(float[] scale) {
        this.scale = scale;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public float[] getTranslation() {
        return this.translation;
    }

    public float[] getScale() {
        return this.scale;
    }

    public void setModelState(ModelState modelState) {
        this.modelState = modelState;
    }

    public void addQuad(@Nullable Direction facing, BakedQuad quad) {
        if (facing != null) {
            this.faceQuads.get(facing).add(quad);
        } else {
            this.generalQuads.add(quad);
        }
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        List modelQuads;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Pair<BlockState, BakedModel> model : this.models) {
            modelQuads = ((BakedModel)model.getRight()).m_213637_((BlockState)model.getLeft(), side, rand);
            if (modelQuads.isEmpty()) continue;
            quads.addAll(modelQuads);
        }
        if (side != null) {
            quads.addAll((Collection)this.faceQuads.get(side));
        }
        quads.addAll(this.generalQuads);
        for (Pair<BlockState, BakedModel> model : this.modelsPost) {
            modelQuads = ((BakedModel)model.getRight()).m_213637_((BlockState)model.getLeft(), side, rand);
            if (modelQuads.isEmpty()) continue;
            quads.addAll(modelQuads);
        }
        return quads;
    }

    public ModelBakerModel copy() {
        return new ModelBakerModel(this);
    }
}

