/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import forestry.core.utils.ModUtil;
import forestry.storage.client.FilledCrateModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class FluidContainerModel
implements IUnbakedGeometry<FluidContainerModel> {
    public static final ItemColor DYNAMIC_COLOR = new DynamicFluidContainerModel.Colors();
    private final Fluid fluid;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    public FluidContainerModel(Fluid fluid, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public FluidContainerModel withFluid(Fluid newFluid) {
        return new FluidContainerModel(newFluid, this.coverIsMask, this.applyFluidLuminosity);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        List quads;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid") ? context.getMaterial("fluid") : null;
        Material coverLocation = context.hasMaterial("cover") ? context.getMaterial("cover") : null;
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        TextureAtlasSprite particleSprite = fluidSprite;
        if (particleSprite == null && baseSprite != null) {
            particleSprite = baseSprite;
        } else if (!this.coverIsMask) {
            particleSprite = coverSprite;
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(baker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseLocation != null && baseSprite != null) {
            List baseElement = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)baseSprite.m_245424_());
            quads = UnbakedGeometryHelper.bakeElements((List)baseElement, $ -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (fluidMaskLocation != null && fluidSprite != null) {
            List<BlockElement> fluidElement = Collections.singletonList(FilledCrateModel.make2dElement(1, 4.0f, 2.0f, 12.0f, 14.0f, -0.002f));
            quads = UnbakedGeometryHelper.bakeElements(fluidElement, $ -> fluidSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                List<BlockElement> coverElement = Collections.singletonList(FilledCrateModel.make2dElement(2, 0.0f, 0.0f, 16.0f, 16.0f, 0.002f));
                List quads2 = UnbakedGeometryHelper.bakeElements(coverElement, $ -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
                modelBuilder.addQuads(normalRenderTypes, (Collection)quads2);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ModelBaker bakery;
        private final IGeometryBakingContext owner;
        private final FluidContainerModel parent;

        private ContainedFluidOverrideHandler(ModelBaker bakery, IGeometryBakingContext owner, FluidContainerModel parent) {
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> {
                Fluid fluid = fluidStack.getFluid();
                String name = ModUtil.getRegistryName(fluid).toString();
                if (!this.cache.containsKey(name)) {
                    FluidContainerModel unbaked = this.parent.withFluid(fluid);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("forge:bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static enum Loader implements IGeometryLoader<FluidContainerModel>
    {
        INSTANCE;


        public FluidContainerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            boolean coverIsMask = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new FluidContainerModel(Fluids.f_76191_, coverIsMask, applyFluidLuminosity);
        }
    }
}

