/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import forestry.core.blocks.IColoredBlock;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.ModUtil;
import forestry.core.utils.ResourceUtil;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;

public enum ClientManager {
    INSTANCE;

    public static final ItemColor FORESTRY_ITEM_COLOR;
    public static final BlockColor FORESTRY_BLOCK_COLOR;
    private final List<BlockModelEntry> customBlockModels = new ArrayList<BlockModelEntry>();
    private final List<ModelEntry> customModels = new ArrayList<ModelEntry>();
    @Nullable
    private ModelState defaultBlockState;

    public ModelState getDefaultBlockState() {
        if (this.defaultBlockState == null) {
            this.defaultBlockState = ResourceUtil.loadTransform(new ResourceLocation("block/block"));
        }
        return this.defaultBlockState;
    }

    public void registerModel(BakedModel model, Object feature) {
        if (feature instanceof FeatureGroup) {
            FeatureGroup group = (FeatureGroup)feature;
            group.getFeatures().forEach(f -> this.registerModel(model, f));
        } else if (feature instanceof FeatureTable) {
            FeatureTable group = (FeatureTable)feature;
            group.getFeatures().forEach(f -> this.registerModel(model, f));
        } else if (feature instanceof FeatureBlock) {
            FeatureBlock block = (FeatureBlock)feature;
            this.registerModel(model, (Block)block.block(), (BlockItem)block.item());
        } else if (feature instanceof FeatureItem) {
            FeatureItem item = (FeatureItem)feature;
            this.registerModel(model, (Item)item.item());
        }
    }

    public void registerModel(BakedModel model, Block block, @Nullable BlockItem item) {
        this.registerModel(model, block, item, (Collection<BlockState>)block.m_49965_().m_61056_());
    }

    public void registerModel(BakedModel model, Block block, @Nullable BlockItem item, Collection<BlockState> states) {
        this.customBlockModels.add(new BlockModelEntry(model, block, item, states));
    }

    public void registerModel(BakedModel model, Item item) {
        this.customModels.add(new ModelEntry(new ModelResourceLocation(ModUtil.getRegistryName(item), "inventory"), model));
    }

    public void onBakeModels(ModelEvent.ModifyBakingResult event) {
        Map registry = event.getModels();
        for (BlockModelEntry blockModelEntry : this.customBlockModels) {
            ResourceLocation registryName;
            for (BlockState state : blockModelEntry.states) {
                registry.put(BlockModelShaper.m_110895_((BlockState)state), blockModelEntry.model);
            }
            if (blockModelEntry.item == null || (registryName = ModUtil.getRegistryName((Item)blockModelEntry.item)) == null) continue;
            registry.put(new ModelResourceLocation(registryName, "inventory"), blockModelEntry.model);
        }
        for (ModelEntry modelEntry : this.customModels) {
            registry.put(modelEntry.modelLocation, modelEntry.model);
        }
    }

    static {
        FORESTRY_ITEM_COLOR = (stack, tintIndex) -> {
            Item item = stack.m_41720_();
            if (item instanceof IColoredItem) {
                IColoredItem coloredItem = (IColoredItem)item;
                return coloredItem.getColorFromItemStack(stack, tintIndex);
            }
            return 0xFFFFFF;
        };
        FORESTRY_BLOCK_COLOR = (state, level, pos, tintIndex) -> {
            Block block = state.m_60734_();
            if (level != null && pos != null && block instanceof IColoredBlock) {
                IColoredBlock coloredBlock = (IColoredBlock)block;
                return coloredBlock.colorMultiplier(state, level, pos, tintIndex);
            }
            return 0xFFFFFF;
        };
    }

    private record BlockModelEntry(BakedModel model, Block block, @Nullable BlockItem item, Collection<BlockState> states) {
    }

    private record ModelEntry(ModelResourceLocation modelLocation, BakedModel model) {
    }
}

