/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.fluids.ForestryFluids;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.DrinkProperties;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.FluidHandlerItemForestry;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.models.FluidContainerModel;
import forestry.core.utils.ModUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemFluidContainerForestry
extends ItemForestry
implements IColoredItem {
    private final EnumContainerType type;

    public ItemFluidContainerForestry(EnumContainerType type) {
        super(new Item.Properties());
        this.type = type;
    }

    public EnumContainerType getType() {
        return this.type;
    }

    protected FluidStack getContained(ItemStack itemStack) {
        if (itemStack.m_41613_() != 1) {
            itemStack = itemStack.m_41777_();
            itemStack.m_41764_(1);
        }
        FluidHandlerItemForestry fluidHandler = new FluidHandlerItemForestry(itemStack, this.type);
        return fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
    }

    public Component m_7626_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemFluidContainerForestry) {
            FluidStack fluid = this.getContained(stack);
            if (!fluid.isEmpty()) {
                String exactTranslationKey = "item.forestry." + this.type.m_7912_() + "." + ModUtil.getRegistryName(fluid.getFluid());
                return Translator.tryTranslate(exactTranslationKey, () -> {
                    String grammarKey = "item.forestry." + this.type.m_7912_() + ".grammar";
                    return Component.m_237110_((String)grammarKey, (Object[])new Object[]{fluid.getDisplayName()});
                });
            }
            String unlocalizedname = "item.forestry." + this.type.m_7912_() + ".empty";
            return Component.m_237115_((String)unlocalizedname);
        }
        return super.m_7626_(stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player player;
        DrinkProperties drinkProperties = this.getDrinkProperties(stack);
        if (drinkProperties != null && entityLiving instanceof Player && !(player = (Player)entityLiving).m_7500_()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!worldIn.f_46443_) {
                FoodData foodStats = player.m_36324_();
                foodStats.m_38707_(drinkProperties.getHealAmount(), drinkProperties.getSaturationModifier());
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, worldIn.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return stack;
    }

    @Nullable
    protected DrinkProperties getDrinkProperties(ItemStack itemStack) {
        ForestryFluids definition;
        FluidStack contained = this.getContained(itemStack);
        if (!contained.isEmpty() && (definition = ForestryFluids.getFluidDefinition(contained)) != null) {
            return definition.getDrinkProperties();
        }
        return null;
    }

    public int m_8105_(ItemStack itemstack) {
        DrinkProperties drinkProperties = this.getDrinkProperties(itemstack);
        if (drinkProperties != null) {
            return drinkProperties.getMaxItemUseDuration();
        }
        return super.m_8105_(itemstack);
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        DrinkProperties drinkProperties = this.getDrinkProperties(itemstack);
        if (drinkProperties != null) {
            return UseAnim.DRINK;
        }
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        ItemStack heldItem = player.m_21120_(handIn);
        DrinkProperties drinkProperties = this.getDrinkProperties(heldItem);
        if (drinkProperties != null) {
            if (player.m_36391_(false)) {
                player.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldItem);
        }
        BlockHitResult target = ItemFluidContainerForestry.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (target.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        ItemStack singleBucket = heldItem.m_41777_();
        singleBucket.m_41764_(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (Player)player, (Level)world, (BlockPos)target.m_82425_(), (Direction)target.m_82434_());
        if (filledResult.isSuccess()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)filledResult.result);
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return super.m_7203_(world, player, handIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemForestry(stack, this.type);
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        return FluidContainerModel.DYNAMIC_COLOR.m_92671_(stack, tintIndex);
    }
}

