/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TextLayoutHelper {
    private static final int LINE_HEIGHT = 12;
    private final GuiForestry<?> screen;
    private final int defaultFontColor;
    private final Font font;
    public int column0;
    public int column1;
    public int column2;
    public int line;

    public TextLayoutHelper(GuiForestry<?> gui, ColourProperties fontColour) {
        this.screen = gui;
        this.font = gui.font();
        this.defaultFontColor = fontColour.get("gui.screen");
    }

    public void startPage(GuiGraphics matrices) {
        this.line = 12;
        matrices.m_280168_().m_85836_();
    }

    public void startPage(GuiGraphics matrices, int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage(matrices);
    }

    public int getLineY() {
        return this.line;
    }

    public void newLine() {
        this.line += 12;
    }

    public void newLineCompressed() {
        this.line += 10;
    }

    public void newLine(int lineHeight) {
        this.line += lineHeight;
    }

    public void endPage(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
    }

    public void drawRow(GuiGraphics graphics, Component text0, Component text1, Component text2, int colour0, int colour1, int colour2) {
        this.drawLine(graphics, text0, this.column0, colour0);
        this.drawLine(graphics, text1, this.column1, colour1);
        this.drawLine(graphics, text2, this.column2, colour2);
    }

    public void drawRow(GuiGraphics graphics, Component text0, Component text1, int colour0, int colour1) {
        this.drawLine(graphics, text0, this.column0, colour0);
        this.drawLine(graphics, text1, this.column1, colour1);
    }

    public void drawLine(GuiGraphics graphics, Component text, int x) {
        this.drawLine(graphics, text, x, this.defaultFontColor);
    }

    public void drawCenteredLine(GuiGraphics graphics, Component text, int x, int color) {
        this.drawCenteredLine(graphics, text, x, this.screen.getSizeX(), color);
    }

    public void drawCenteredLine(GuiGraphics graphics, Component text, int x, int width, int color) {
        this.drawCenteredLine(graphics, text, x, 0, width, color);
    }

    public void drawCenteredLine(GuiGraphics graphics, Component text, int x, int y, int width, int color) {
        graphics.m_280614_(this.font, text, this.screen.getGuiLeft() + x + this.getCenteredOffset(text, width), this.screen.getGuiTop() + y + this.line, color, false);
    }

    public void drawLine(GuiGraphics graphics, String text, int x, int color) {
        this.drawLine(graphics, text, x, 0, color);
    }

    public void drawLine(GuiGraphics graphics, Component text, int x, int color) {
        this.drawLine(graphics, text, x, 0, color);
    }

    public void drawLine(GuiGraphics graphics, String text, int x, int y, int color) {
        graphics.m_280056_(this.font, text, this.screen.getGuiLeft() + x, this.screen.getGuiTop() + y + this.line, color, false);
    }

    public void drawLine(GuiGraphics graphics, Component text, int x, int y, int color) {
        graphics.m_280614_(this.font, text, this.screen.getGuiLeft() + x, this.screen.getGuiTop() + y + this.line, color, false);
    }

    public void drawSplitLine(GuiGraphics graphics, String text, int x, int maxWidth, int color) {
        this.drawSplitLine(graphics, (Component)Component.m_237113_((String)text), x, maxWidth, color);
    }

    public void drawSplitLine(GuiGraphics graphics, Component text, int x, int maxWidth, int color) {
        graphics.m_280554_(this.font, (FormattedText)text, this.screen.getGuiLeft() + x, this.screen.getGuiTop() + this.line, maxWidth, color);
    }

    public int getCenteredOffset(Component text) {
        return this.getCenteredOffset(text, this.screen.getSizeX());
    }

    public int getCenteredOffset(Component text, int xWidth) {
        return (xWidth - this.screen.font().m_92852_((FormattedText)text)) / 2;
    }
}

