/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.tooltips.IToolTipProvider;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiForestry;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class GuiUtil {
    public static void drawItemStack(GuiGraphics graphics, GuiForestry<?> gui, ItemStack stack, int xPos, int yPos) {
        GuiUtil.drawItemStack(graphics, gui.font(), stack, xPos, yPos);
    }

    public static void drawItemStack(GuiGraphics graphics, Font font, ItemStack stack, int xPos, int yPos) {
        PoseStack itemRendererStack = graphics.m_280168_();
        itemRendererStack.m_85836_();
        graphics.m_280480_(stack, xPos, yPos);
        graphics.m_280302_(font, stack, xPos, yPos, null);
        itemRendererStack.m_85849_();
    }

    public static void drawToolTips(GuiGraphics graphics, GuiForestry<?> screen, IToolTipProvider provider, ToolTip toolTips, int mouseX, int mouseY) {
        if (!toolTips.isEmpty()) {
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            if (provider == null || provider.isRelativeToGui()) {
                pose.m_252880_((float)(-screen.getGuiLeft()), (float)(-screen.getGuiTop()), 0.0f);
            }
            Window window = Minecraft.m_91087_().m_91268_();
            graphics.m_280677_(screen.font(), toolTips.getLines(), Optional.empty(), mouseX, mouseY);
            pose.m_85849_();
        }
    }

    public static void drawToolTips(GuiGraphics graphics, GuiForestry<?> gui, Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible()) continue;
            int mX = mouseX;
            int mY = mouseY;
            if (provider.isRelativeToGui()) {
                mX -= gui.getGuiLeft();
                mY -= gui.getGuiTop();
            }
            if ((tips = provider.getToolTip(mX, mY)) == null) continue;
            boolean mouseOver = provider.isHovering(mX, mY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            GuiUtil.drawToolTips(graphics, gui, provider, tips, mouseX, mouseY);
        }
    }

    public static String formatEnergyValue(int energy) {
        NumberFormat format = NumberFormat.getIntegerInstance(Minecraft.m_91087_().getLocale());
        return format.format(energy) + " RF";
    }

    public static String formatRate(int rate) {
        return GuiUtil.formatEnergyValue(rate) + "/t";
    }
}

