/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean areFluidStacksEqual(@Nullable FluidStack fluidStack1, @Nullable FluidStack fluidStack2) {
        if (fluidStack1 == null) {
            return fluidStack2 == null;
        }
        return fluidStack1.isFluidStackIdentical(fluidStack2);
    }

    public static boolean canAcceptFluid(Level world, BlockPos pos, Direction facing, FluidStack fluid, boolean checkSpace) {
        LazyOptional capability = FluidUtil.getFluidHandler((Level)world, (BlockPos)pos, (Direction)facing);
        return capability.filter(handler -> {
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                int amountFilled = handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                if (amountFilled <= 0 || checkSpace && amountFilled < fluid.getAmount()) continue;
                return true;
            }
            return false;
        }).isPresent();
    }

    public static boolean canAcceptFluid(Level world, BlockPos pos, Direction facing, FluidStack fluid) {
        return FluidHelper.canAcceptFluid(world, pos, facing, fluid, false);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, Container inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, FluidHelper.getEmptyContainer(inv.m_8020_(inputSlot)), doFill);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, Container inv, int inputSlot, int outputSlot, Fluid fluidToFill, ItemStack emptyStack, boolean doFill) {
        boolean moveToOutput;
        ItemStack input = inv.m_8020_(inputSlot);
        if (input.m_41619_()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack output = inv.m_8020_(outputSlot);
        ItemStack filled = input.m_41777_();
        filled.m_41764_(1);
        if (emptyStack.m_41619_()) {
            emptyStack = filled;
        }
        LazyOptional fluidFilledHandlerCap = FluidUtil.getFluidHandler((ItemStack)filled);
        LazyOptional fluidEmptyHandlerCap = FluidUtil.getFluidHandler((ItemStack)emptyStack);
        if (!fluidFilledHandlerCap.isPresent() || !fluidEmptyHandlerCap.isPresent()) {
            return FillStatus.INVALID_INPUT;
        }
        IFluidHandlerItem fluidFilledHandler = (IFluidHandlerItem)fluidFilledHandlerCap.orElse(null);
        IFluidHandlerItem fluidEmptyHandler = (IFluidHandlerItem)fluidEmptyHandlerCap.orElse(null);
        int containerEmptyCapacity = fluidEmptyHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        int containerCapacity = fluidFilledHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        if (containerCapacity <= 0 && containerEmptyCapacity <= 0) {
            return FillStatus.INVALID_INPUT;
        }
        FluidStack canDrain = fluidHandler.drain(new FluidStack(fluidToFill, containerCapacity), IFluidHandler.FluidAction.SIMULATE);
        if (canDrain.isEmpty()) {
            return FillStatus.NO_FLUID;
        }
        if (fluidFilledHandler.fill(canDrain, IFluidHandler.FluidAction.EXECUTE) <= 0) {
            return FillStatus.NO_FLUID;
        }
        FluidStack fluidInContainer = fluidFilledHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (fluidInContainer.isEmpty()) {
            return FillStatus.INVALID_INPUT;
        }
        filled = fluidFilledHandler.getContainer();
        boolean bl = moveToOutput = fluidInContainer.getAmount() >= containerCapacity;
        if (moveToOutput ? !output.m_41619_() && (output.m_41613_() >= output.m_41741_() || !ItemStackUtil.areItemStacksEqualIgnoreCount(filled, output)) : input.m_41613_() > 1) {
            return FillStatus.NO_SPACE;
        }
        if (doFill) {
            fluidHandler.drain(canDrain, IFluidHandler.FluidAction.EXECUTE);
            if (moveToOutput) {
                if (output.m_41619_()) {
                    inv.m_6836_(outputSlot, filled);
                } else {
                    output.m_41769_(1);
                }
                inv.m_7407_(inputSlot, 1);
            } else {
                inv.m_6836_(inputSlot, filled);
            }
        }
        return FillStatus.SUCCESS;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, Container inv, int inputSlot) {
        FluidActionResult fluidActionResult;
        ItemStack input = inv.m_8020_(inputSlot);
        if (input.m_41619_()) {
            return false;
        }
        FluidActionResult fluidActionSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (!fluidActionSimulated.isSuccess()) {
            return false;
        }
        ItemStack drainedItemSimulated = fluidActionSimulated.getResult();
        if ((input.m_41613_() == 1 || drainedItemSimulated.m_41619_()) && (fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true)).isSuccess()) {
            ItemStack drainedItem = fluidActionResult.getResult();
            if (!drainedItem.m_41619_()) {
                inv.m_6836_(inputSlot, drainedItem);
            } else {
                inv.m_7407_(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static FillStatus drainContainers(IFluidHandler fluidHandler, Container inv, int inputSlot, int outputSlot, boolean doDrain) {
        ItemStack input = inv.m_8020_(inputSlot);
        if (input.m_41619_()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack outputStack = inv.m_8020_(outputSlot);
        FluidStack content = FluidUtil.getFluidContained((ItemStack)input).orElse(FluidStack.EMPTY);
        FluidActionResult drainedResultSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (!drainedResultSimulated.isSuccess()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack drainedItemSimulated = drainedResultSimulated.getResult();
        if (outputStack.m_41619_() || drainedItemSimulated.m_41619_() || ItemStackUtil.isIdenticalItem(outputStack, drainedItemSimulated) && outputStack.m_41613_() + drainedItemSimulated.m_41613_() < outputStack.m_41741_()) {
            FluidActionResult drainedResult;
            if (doDrain && (drainedResult = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true)).isSuccess()) {
                ItemStack drainedItem = drainedResult.getResult();
                if (!drainedItem.m_41619_()) {
                    ItemStack newStack = drainedItem.m_41777_();
                    if (!outputStack.m_41619_()) {
                        newStack.m_41769_(outputStack.m_41613_());
                    }
                    if (!FluidHelper.isFillableContainer(newStack, content) || FluidHelper.isFillableContainerAndEmpty(newStack, content)) {
                        inv.m_6836_(outputSlot, newStack);
                        inv.m_7407_(inputSlot, 1);
                    }
                    if (FluidHelper.isDrainableContainer(newStack) && !FluidHelper.isEmpty(newStack)) {
                        inv.m_6836_(inputSlot, newStack);
                    }
                } else {
                    inv.m_7407_(inputSlot, 1);
                }
                return FillStatus.SUCCESS;
            }
            return FillStatus.SUCCESS;
        }
        return FillStatus.NO_SPACE;
    }

    public static boolean isFillableContainer(ItemStack container, FluidStack content) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        return fluidHandlerCap.filter(handler -> handler.fill(new FluidStack(content, 1), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    public static boolean isFillableContainerAndEmpty(ItemStack container, FluidStack content) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        return fluidHandlerCap.filter(handler -> handler.fill(new FluidStack(content, 1), IFluidHandler.FluidAction.SIMULATE) > 0 && handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()).isPresent();
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        ItemStack empty = container.m_41777_();
        empty.m_41764_(1);
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)empty);
        if (!fluidHandlerCap.isPresent()) {
            return ItemStack.f_41583_;
        }
        return fluidHandlerCap.filter(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE) != null).isPresent() ? empty : ItemStack.f_41583_;
    }

    public static boolean isFillableContainerWithRoom(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isFillableEmptyContainer(ItemStack empty) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)empty);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerCap.orElse(null);
        int capacity = fluidHandler.getTankCapacity(0);
        if (fluidHandler.getFluidInTank(0).getAmount() == capacity) {
            return fluidHandler.drain(capacity, IFluidHandler.FluidAction.SIMULATE).getAmount() == capacity;
        }
        return false;
    }

    public static boolean isDrainableContainer(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isEmpty(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        return fluidHandlerCap.filter(fluidHandler -> {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                if (fluidHandler.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    public static enum FillStatus {
        SUCCESS,
        INVALID_INPUT,
        NO_FLUID,
        NO_SPACE,
        NO_SPACE_FLUID;

    }
}

