/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import forestry.Forestry;
import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.climate.IClimateManager;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.core.ToleranceType;
import forestry.api.genetics.IGeneticManager;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.IChromosome;
import forestry.core.utils.SpeciesUtil;
import forestry.modules.features.FeatureItem;
import forestry.storage.features.BackpackItems;
import forestry.storage.items.ItemBackpack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;

public class DumpCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").then(Commands.m_82127_((String)"mutations").executes(DumpCommand::mutations))).then(Commands.m_82127_((String)"climates").executes(DumpCommand::climates))).then(Commands.m_82127_((String)"backpacks").executes(DumpCommand::backpacks))).then(Commands.m_82127_((String)"bee_species").executes(DumpCommand::beeSpecies))).then(Commands.m_82127_((String)"chromosomes").executes(DumpCommand::chromosomes));
    }

    private static int mutations(CommandContext<CommandSourceStack> ctx) {
        IGeneticManager genetics = IForestryApi.INSTANCE.getGeneticManager();
        for (ISpeciesType<?, ?> type : genetics.getSpeciesTypes()) {
            List<IMutation<?>> mutations = type.getMutations().getAllMutations();
            Forestry.LOGGER.debug("There are {} registered mutations for species type {}", (Object)mutations.size(), (Object)type.id());
            for (IMutation<?> mutation : mutations) {
                Forestry.LOGGER.debug("> {} + {} = {}", (Object)mutation.getFirstParent().id(), (Object)mutation.getSecondParent().id(), (Object)mutation.getResult().id());
            }
            Forestry.LOGGER.debug("=======");
        }
        return 1;
    }

    private static int climates(CommandContext<CommandSourceStack> ctx) {
        List biomes = ((CommandSourceStack)ctx.getSource()).m_81372_().m_9598_().m_175515_(Registries.f_256952_).m_203611_().toList();
        Forestry.LOGGER.debug("Listing Forestry climates for {} biomes", (Object)biomes.size());
        Table<HumidityType, TemperatureType, List<ResourceLocation>> climates = DumpCommand.createClimatesTable(ctx);
        for (TemperatureType temperature : TemperatureType.VALUES) {
            for (HumidityType humidity : HumidityType.VALUES) {
                List climateList = (List)climates.get((Object)humidity, (Object)temperature);
                if (climateList == null || climateList.isEmpty()) {
                    Forestry.LOGGER.error("No biomes found with climate ({} / {})", (Object)temperature, (Object)humidity);
                    continue;
                }
                Forestry.LOGGER.debug("Found {} biomes with climate ({} / {}): ", (Object)climateList.size(), (Object)temperature, (Object)humidity);
                for (ResourceLocation biomeId : climateList) {
                    Forestry.LOGGER.debug("  > {}", (Object)biomeId);
                }
            }
        }
        Forestry.LOGGER.debug("Finished listing Forestry climates.");
        return 1;
    }

    private static Table<HumidityType, TemperatureType, List<ResourceLocation>> createClimatesTable(CommandContext<CommandSourceStack> ctx) {
        List biomes = ((CommandSourceStack)ctx.getSource()).m_81372_().m_9598_().m_175515_(Registries.f_256952_).m_203611_().toList();
        HashBasedTable climates = HashBasedTable.create((int)HumidityType.VALUES.size(), (int)TemperatureType.VALUES.size());
        IClimateManager manager = IForestryApi.INSTANCE.getClimateManager();
        for (Holder.Reference biome : biomes) {
            TemperatureType temperature;
            HumidityType humidity = manager.getHumidity((Holder<Biome>)biome);
            ArrayList<ResourceLocation> climateList = (ArrayList<ResourceLocation>)climates.get((Object)humidity, (Object)(temperature = manager.getTemperature((Holder<Biome>)biome)));
            if (climateList == null) {
                climateList = new ArrayList<ResourceLocation>();
                climates.put((Object)humidity, (Object)temperature, climateList);
            }
            climateList.add(biome.m_205785_().m_135782_());
        }
        return climates;
    }

    private static int backpacks(CommandContext<CommandSourceStack> ctx) {
        List<FeatureItem<?>> definitions = List.of(BackpackItems.MINER_BACKPACK, BackpackItems.DIGGER_BACKPACK, BackpackItems.FORESTER_BACKPACK, BackpackItems.HUNTER_BACKPACK, BackpackItems.ADVENTURER_BACKPACK, BackpackItems.BUILDER_BACKPACK);
        Forestry.LOGGER.debug("Listing Forestry backpack filters for {} backpack types (excluding Naturalist bags)", (Object)definitions.size());
        for (FeatureItem<?> backpack : definitions) {
            Predicate<ItemStack> filter = ((ItemBackpack)backpack.get()).getDefinition().getFilter();
            ArrayList<Item> allowedItems = new ArrayList<Item>();
            for (Item item : ((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256913_)) {
                if (!filter.test(new ItemStack((ItemLike)item))) continue;
                allowedItems.add(item);
            }
            Forestry.LOGGER.debug("The backpack definition {} allows {} items:", (Object)((ItemBackpack)backpack.item()).m_204114_().m_205785_().m_135782_(), (Object)allowedItems.size());
            for (Item allowedItem : allowedItems) {
                Forestry.LOGGER.debug("  > {}", (Object)allowedItem.m_204114_().m_205785_().m_135782_());
            }
        }
        return 1;
    }

    private static int beeSpecies(CommandContext<CommandSourceStack> ctx) {
        IBeeSpeciesType beeType = (IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get();
        List allSpecies = beeType.getAllSpecies();
        Table<HumidityType, TemperatureType, List<ResourceLocation>> climatesTable = DumpCommand.createClimatesTable(ctx);
        try {
            Forestry.LOGGER.debug("Listing properties of all {} bee species", (Object)allSpecies.size());
            for (IBeeSpecies species : allSpecies) {
                IGenome defaultGenome = species.getDefaultGenome();
                TemperatureType temperature = species.getTemperature();
                HumidityType humidity = species.getHumidity();
                Forestry.LOGGER.debug("PROPERTIES OF BEE SPECIES {}:", (Object)species.id());
                Forestry.LOGGER.debug("  Primary Stats:");
                Forestry.LOGGER.debug("    Lifespan: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.LIFESPAN).getString());
                Forestry.LOGGER.debug("    Production: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.SPEED).getString());
                Forestry.LOGGER.debug("    Pollination: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.POLLINATION).getString());
                Forestry.LOGGER.debug("    Fertility: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.FERTILITY).getString());
                Forestry.LOGGER.debug("    Territory: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.TERRITORY).getString());
                Forestry.LOGGER.debug("    Effect: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.EFFECT).getString());
                Forestry.LOGGER.debug("  Secondary Stats:");
                Forestry.LOGGER.debug("    Temperature: {}, {}", (Object)temperature, (Object)defaultGenome.getActiveName(BeeChromosomes.TEMPERATURE_TOLERANCE).getString());
                Forestry.LOGGER.debug("    Humidity: {}, {}", (Object)humidity, (Object)defaultGenome.getActiveName(BeeChromosomes.HUMIDITY_TOLERANCE).getString());
                Forestry.LOGGER.debug("    Activity: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.ACTIVITY));
                Forestry.LOGGER.debug("    Tolerant flyer: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.TOLERATES_RAIN).getString());
                Forestry.LOGGER.debug("    Cave-dwelling: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.CAVE_DWELLING).getString());
                Forestry.LOGGER.debug("    Flower Type: {}", (Object)defaultGenome.getActiveName(BeeChromosomes.FLOWER_TYPE).getString());
                ArrayList suitableBiomes = new ArrayList();
                ToleranceType temperatureTolerance = defaultGenome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE);
                ToleranceType humidityTolerance = defaultGenome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE);
                int maxTemperature = Math.min(temperature.ordinal() + temperatureTolerance.up, TemperatureType.VALUES.size() - 1);
                int maxHumidity = Math.min(humidity.ordinal() + humidityTolerance.up, HumidityType.VALUES.size() - 1);
                for (int t = temperature.down(temperatureTolerance.down).ordinal(); t <= maxTemperature; ++t) {
                    for (int h = humidity.down(humidityTolerance.down).ordinal(); h <= maxHumidity; ++h) {
                        List validBiomes = (List)climatesTable.get((Object)HumidityType.VALUES.get(h), (Object)TemperatureType.VALUES.get(t));
                        if (validBiomes == null) continue;
                        suitableBiomes.addAll(validBiomes);
                    }
                }
                Forestry.LOGGER.debug("  Found {} Suitable Biomes:", (Object)suitableBiomes.size());
                for (ResourceLocation biome : suitableBiomes) {
                    Forestry.LOGGER.debug("    {}", (Object)biome);
                }
            }
        }
        catch (Throwable throwable) {
            Forestry.LOGGER.debug("Uh oh", throwable);
        }
        return 1;
    }

    private static int chromosomes(CommandContext<CommandSourceStack> ctx) {
        for (ISpeciesType<?, ?> speciesType : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
            ImmutableList<IChromosome<?>> chromosomes = speciesType.getKaryotype().getChromosomes();
            Forestry.LOGGER.debug("ISpeciesType \"{}\" has {} chromosomes:", (Object)speciesType.id(), (Object)chromosomes.size());
            for (IChromosome chromosome : chromosomes) {
                Forestry.LOGGER.debug("  {} - {} -> \"{}\"", (Object)chromosome.id(), (Object)chromosome.getChromosomeTranslationKey(), (Object)chromosome.getChromosomeDisplayName().getString());
            }
        }
        return 1;
    }
}

