/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BlockHumus
extends Block {
    private static final int DEGRADE_STEPS = 3;
    public static final IntegerProperty DEGRADE = IntegerProperty.m_61631_((String)"degrade", (int)0, (int)3);

    public BlockHumus() {
        super(BlockBehaviour.Properties.m_284310_().m_60977_().m_60978_(0.5f).m_60918_(SoundType.f_56739_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DEGRADE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DEGRADE});
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (world.f_46443_ || world.f_46441_.m_188503_(140) != 0) {
            return;
        }
        if (BlockHumus.isEnrooted((Level)world, pos)) {
            BlockHumus.degradeSoil((Level)world, pos);
        }
    }

    private static boolean isEnrooted(Level world, BlockPos pos) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                BlockPos blockPos = pos.m_7918_(i, 1, j);
                BlockState state = world.m_8055_(blockPos);
                Block block = state.m_60734_();
                if (!state.m_204336_(BlockTags.f_13106_) && !(block instanceof BonemealableBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private static void degradeSoil(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        int degrade = (Integer)blockState.m_61143_((Property)DEGRADE);
        if (++degrade >= 3) {
            world.m_7731_(pos, Blocks.f_49992_.m_49966_(), 2);
        } else {
            world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)DEGRADE, (Comparable)Integer.valueOf(degrade)), 2);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos);
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }
}

