/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TreeContour {
    public static final TreeContour EMPTY = new Empty();

    public void addLeaf(BlockPos var1);

    public List<BlockPos> getBranchEnds();

    public boolean hasLeaf(BlockPos var1);

    public static final class Empty
    implements TreeContour {
        private Empty() {
        }

        @Override
        public void addLeaf(BlockPos pos) {
        }

        @Override
        public boolean hasLeaf(BlockPos pos) {
            return false;
        }

        @Override
        public List<BlockPos> getBranchEnds() {
            return List.of();
        }
    }

    public static final class Impl
    implements TreeContour {
        public final Set<BlockPos> leavePositions = new HashSet<BlockPos>();
        public final List<BlockPos> branchEnds;
        @Nullable
        public BoundingBox boundingBox;

        public Impl(List<BlockPos> branchEnds) {
            this.branchEnds = branchEnds;
            this.boundingBox = null;
        }

        @Override
        public void addLeaf(BlockPos pos) {
            this.leavePositions.add(pos.m_7949_());
            if (this.boundingBox == null) {
                this.boundingBox = new BoundingBox(pos);
            } else {
                this.boundingBox.m_162371_(pos);
            }
        }

        @Override
        public boolean hasLeaf(BlockPos pos) {
            return this.leavePositions.contains(pos);
        }

        @Override
        public List<BlockPos> getBranchEnds() {
            return this.branchEnds;
        }
    }
}

