/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.api.genetics.IGenome;
import forestry.arboriculture.worldgen.FeatureArboriculture;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public abstract class FeatureTree
extends FeatureArboriculture {
    private static final int minHeight = 4;
    private static final int maxHeight = 80;
    private final int baseHeight;
    private final int heightVariation;
    protected int girth;
    protected int height;

    protected FeatureTree(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree);
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor level, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(level, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        return Set.of();
    }

    @Override
    protected void generateLeaves(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafHeight = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafHeight--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafHeight--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafHeight--, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafHeight, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
    }

    @Override
    protected void generateExtras(LevelAccessor level, RandomSource rand, BlockPos startPos) {
        if (this.hasPods()) {
            FeatureHelper.generatePods(this.tree, level, rand, startPos, this.height, 3, this.girth, FeatureHelper.EnumReplaceMode.AIR);
        }
    }

    @Override
    @Nullable
    public BlockPos getValidGrowthPos(LevelAccessor level, BlockPos pos) {
        return this.tree.getGrowthPos(this.tree.getDefaultGenome(), level, pos, this.girth, this.height);
    }

    @Override
    public final void preGenerate(IGenome genome, LevelAccessor level, RandomSource rand, BlockPos startPos) {
        this.height = this.determineHeight(level, rand, genome, this.baseHeight, this.heightVariation);
        this.girth = this.tree.getGirth(genome);
    }

    protected int modifyByHeight(LevelAccessor world, int val, int min, int max) {
        int determined = Math.round((float)val * this.tree.getHeightModifier(this.tree.getDefaultGenome()));
        return determined < min ? min : Math.min(determined, max);
    }

    protected int determineHeight(LevelAccessor world, RandomSource rand, IGenome genome, int baseHeight, int heightVariation) {
        int height = baseHeight + rand.m_188503_(heightVariation);
        int adjustedHeight = Math.round((float)height * this.tree.getHeightModifier(genome));
        return adjustedHeight < 4 ? 4 : Math.min(adjustedHeight, 80);
    }
}

