/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.core.utils.SpeciesUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class GrafterLootModifier
extends LootModifier {
    public static final Codec<GrafterLootModifier> CODEC = RecordCodecBuilder.create(inst -> GrafterLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GrafterLootModifier::new));

    public GrafterLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state == null || !state.m_204336_(BlockTags.f_13035_)) {
            return generatedLoot;
        }
        ItemStack harvestingTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (harvestingTool == null || harvestingTool.m_41619_()) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof Player)) {
            return generatedLoot;
        }
        Player player = (Player)entity;
        if (generatedLoot.stream().noneMatch(stack -> stack.m_204117_(ItemTags.f_13180_))) {
            this.handleLoot((List<ItemStack>)generatedLoot, player, harvestingTool, state, context);
        }
        harvestingTool.m_220157_(1, context.m_230907_(), (ServerPlayer)player);
        if (harvestingTool.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)harvestingTool, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        return generatedLoot;
    }

    public void handleLoot(List<ItemStack> generatedLoot, Player player, ItemStack harvestingTool, BlockState state, LootContext context) {
        IGenome genome;
        IFruit fruitProvider;
        Level world = player.m_9236_();
        BlockEntity tileEntity = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        ITree tree = this.getTree(state, tileEntity);
        if (tree == null) {
            return;
        }
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (origin == null) {
            return;
        }
        BlockPos pos = BlockPos.m_274446_((Position)origin);
        Item item = harvestingTool.m_41720_();
        float saplingModifier = 1.0f;
        if (item instanceof IToolGrafter) {
            saplingModifier = ((IToolGrafter)item).getSaplingModifier(harvestingTool, world, player, pos);
        }
        List<ITree> saplings = tree.getSaplings(world, pos, player.m_36316_(), saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            generatedLoot.add(sapling.createStack(TreeLifeStage.SAPLING));
        }
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer bearer = (IFruitBearer)tileEntity;
            generatedLoot.addAll(bearer.pickFruit(harvestingTool));
        }
        if (state.m_60734_() instanceof BlockDefaultLeavesFruit && (fruitProvider = (genome = tree.getGenome()).getActiveValue(TreeChromosomes.FRUIT)).isFruitLeaf()) {
            generatedLoot.addAll(tree.produceStacks(world, pos, Integer.MAX_VALUE));
        }
    }

    @Nullable
    private ITree getTree(BlockState state, @Nullable BlockEntity entity) {
        ITreeSpeciesType type = (ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get();
        ITree tree = type.getVanillaIndividual(state);
        if (tree != null || entity == null) {
            return tree;
        }
        return type.getTree(entity);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

