/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.genetics.ITree;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.tiles.TileUtil;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TreeGrowthHelper {
    @Nullable
    public static BlockPos getGrowthPos(LevelAccessor level, IGenome genome, BlockPos pos, int expectedGirth, int expectedHeight) {
        BlockPos growthPos = TreeGrowthHelper.hasSufficientSaplingsAroundSapling(genome, level, pos, expectedGirth);
        if (growthPos == null) {
            return null;
        }
        if (!TreeGrowthHelper.hasRoom(level, growthPos, expectedGirth, expectedHeight)) {
            return null;
        }
        return growthPos;
    }

    private static boolean hasRoom(LevelAccessor level, BlockPos pos, int expectedGirth, int expectedHeight) {
        Vec3i area = new Vec3i(expectedGirth, expectedHeight + 1, expectedGirth);
        return TreeGrowthHelper.checkArea(level, pos.m_7494_(), area);
    }

    private static boolean checkArea(LevelAccessor level, BlockPos start, Vec3i area) {
        for (int x = 0; x < area.m_123341_(); ++x) {
            for (int y = 0; y < area.m_123342_(); ++y) {
                for (int z = 0; z < area.m_123343_(); ++z) {
                    BlockPos pos = start.m_7918_(x, y, z);
                    BlockState blockState = level.m_8055_(pos);
                    if (blockState.m_247087_() || blockState.m_204336_(BlockTags.f_13035_)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static BlockPos hasSufficientSaplingsAroundSapling(IGenome genome, LevelAccessor world, BlockPos saplingPos, int expectedGirth) {
        int checkSize = expectedGirth * 2 - 1;
        int offset = expectedGirth - 1;
        Object2BooleanOpenHashMap knownSaplings = new Object2BooleanOpenHashMap(checkSize * checkSize);
        for (int x = -offset; x <= 0; ++x) {
            for (int z = -offset; z <= 0; ++z) {
                BlockPos startPos = saplingPos.m_7918_(x, 0, z);
                if (!TreeGrowthHelper.checkForSaplings(genome, world, startPos, expectedGirth, (Object2BooleanOpenHashMap<BlockPos>)knownSaplings)) continue;
                return startPos;
            }
        }
        return null;
    }

    private static boolean checkForSaplings(IGenome genome, LevelAccessor level, BlockPos startPos, int girth, Object2BooleanOpenHashMap<BlockPos> knownSaplings) {
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                BlockPos checkPos = startPos.m_7918_(x, 0, z);
                boolean knownSapling = knownSaplings.computeIfAbsent((Object)checkPos, k -> TreeGrowthHelper.isSapling(genome, level, checkPos));
                if (knownSapling) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isSapling(IGenome genome, LevelAccessor level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            return false;
        }
        if (level.m_46859_(pos)) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((BlockGetter)level, pos, TileSapling.class);
        if (sapling == null) {
            return false;
        }
        ITree tree = sapling.getTree();
        return tree != null && tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES) == genome.getActiveAllele(TreeChromosomes.SPECIES);
    }
}

