/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.ForestryTags;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ILifeStage;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockForestryLeaves
extends BlockAbstractLeaves
implements BonemealableBlock,
EntityBlock {
    @Override
    protected ITree getTree(BlockGetter world, BlockPos pos) {
        TileLeaves leaves = TileUtil.getTile(world, pos, TileLeaves.class);
        if (leaves != null) {
            return leaves.getTree();
        }
        return null;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.m_213898_(state, world, pos, rand);
        TileLeaves tileLeaves = TileUtil.getTile((BlockGetter)world, pos, TileLeaves.class);
        if (tileLeaves != null && !tileLeaves.m_58901_() && (double)rand.m_188501_() <= 0.1) {
            tileLeaves.onBlockTick((Level)world, pos, state, rand);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) == false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileLeaves(pos, state);
    }

    @Override
    protected void getLeafDrop(List<ItemStack> drops, Level level, @Nullable BlockPos pos, @Nullable GameProfile profile, float saplingModifier, int fortune, LootParams.Builder context) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TileLeaves)) {
            return;
        }
        TileLeaves leaves = (TileLeaves)blockEntity;
        ITree tree = leaves.getTree();
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(level, pos, profile, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add(((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).createStack(sapling, (ILifeStage)TreeLifeStage.SAPLING));
        }
        if (leaves.hasFruit()) {
            drops.addAll(tree.produceStacks(level, pos, leaves.getRipeningTime()));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileLeaves leaves = TileUtil.getTile((BlockGetter)level, pos, TileLeaves.class);
        if (leaves != null) {
            IButterfly caterpillar = leaves.getCaterpillar();
            ItemStack heldItem = player.m_21120_(hand);
            ItemStack otherHand = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            if (heldItem.m_41619_() && otherHand.m_41619_()) {
                if (leaves.hasFruit() && leaves.getRipeness() >= 0.9f) {
                    BlockUtil.sendDestroyEffects(level, pos, state);
                    for (ItemStack fruit : leaves.pickFruit(ItemStack.f_41583_)) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)fruit);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_204117_(ForestryTags.Items.SCOOPS) && caterpillar != null) {
                ItemStack butterfly = ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).createStack(caterpillar, (ILifeStage)ButterflyLifeStage.CATERPILLAR);
                ItemStackUtil.dropItemStackAsEntity(butterfly, level, pos.m_7495_());
                leaves.setCaterpillar(null);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        TileLeaves leafTile = TileUtil.getTile((BlockGetter)world, pos, TileLeaves.class);
        return leafTile != null && leafTile.hasFruit() && leafTile.getRipeness() < 1.0f;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        TileLeaves leafTile = TileUtil.getTile((BlockGetter)world, pos, TileLeaves.class);
        if (leafTile != null) {
            leafTile.addRipeness(0.5f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        TileLeaves leaves;
        if (level != null && pos != null && (leaves = TileUtil.getTile((BlockGetter)level, pos, TileLeaves.class)) != null) {
            if (tintIndex == 2) {
                return leaves.getFruitColour();
            }
            return leaves.getFoliageColour();
        }
        return FoliageColor.m_46113_();
    }
}

