/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearySwarmer;
import forestry.apiculture.hives.Hive;
import forestry.apiculture.hives.HiveDecorator;
import forestry.apiculture.hives.HiveDefinitionSwarmer;
import forestry.apiculture.inventory.InventorySwarmer;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.SpeciesUtil;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public class TileAlvearySwarmer
extends TileAlveary
implements WorldlyContainer,
IActivatable,
IAlvearyComponent.Active<MultiblockLogicAlveary> {
    private final InventorySwarmer inventory;
    private final ArrayDeque<ItemStack> pendingSpawns = new ArrayDeque();

    public TileAlvearySwarmer(BlockPos pos, BlockState state) {
        super(BlockAlvearyType.SWARMER, pos, state);
        this.inventory = new InventorySwarmer(this);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        if (!this.pendingSpawns.isEmpty()) {
            this.setActive(true);
            if (tickCount % 300 == 0) {
                this.trySpawnSwarm();
            }
        } else {
            this.setActive(false);
        }
        if (tickCount % 500 != 0) {
            return;
        }
        ItemStack princessStack = this.getPrincessStack();
        if (princessStack == null) {
            return;
        }
        float chance = this.consumeInducerAndGetChance();
        if (chance == 0.0f) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188501_() < chance) {
            IIndividualHandlerItem.ifPresent(princessStack, individual -> {
                if (individual instanceof IBee) {
                    IBee princess = (IBee)individual;
                    princess.setPristine(false);
                    this.pendingSpawns.push(princess.createStack(BeeLifeStage.PRINCESS));
                    princess.setPristine(true);
                }
            });
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    @Nullable
    private ItemStack getPrincessStack() {
        ItemStack princessStack = ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory().getQueen();
        if (((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).isMated(princessStack)) {
            return princessStack;
        }
        return null;
    }

    private float consumeInducerAndGetChance() {
        for (int slotIndex = 0; slotIndex < this.m_6643_(); ++slotIndex) {
            ItemStack stack = this.m_8020_(slotIndex);
            float chance = IForestryApi.INSTANCE.getHiveManager().getSwarmingMaterialChance(stack.m_41720_());
            if (chance == 0.0f) continue;
            this.m_7407_(slotIndex, 1);
            return chance;
        }
        return 0.0f;
    }

    private void trySpawnSwarm() {
        int z;
        ItemStack toSpawn = this.pendingSpawns.peek();
        HiveDefinitionSwarmer hiveDescription = new HiveDefinitionSwarmer(toSpawn);
        Hive hive = new Hive(hiveDescription, hiveDescription.getGenChance(), List.of());
        ServerLevel level = (ServerLevel)this.f_58857_;
        int x = this.m_58899_().m_123341_() + level.f_46441_.m_188503_(80) - 40;
        if (HiveDecorator.tryGenHive((WorldGenLevel)level, level.f_46441_, x, z = this.m_58899_().m_123343_() + level.f_46441_.m_188503_(80) - 40, hive)) {
            this.pendingSpawns.pop();
        }
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        ListTag nbttaglist = compoundNBT.m_128437_("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag compoundNBT1 = nbttaglist.m_128728_(i);
            this.pendingSpawns.add(ItemStack.m_41712_((CompoundTag)compoundNBT1));
        }
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        ListTag nbttaglist = new ListTag();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[0]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            CompoundTag compoundNBT1 = new CompoundTag();
            compoundNBT1.m_128344_("Slot", (byte)i);
            offspring[i].m_41739_(compoundNBT1);
            nbttaglist.add((Object)compoundNBT1);
        }
        compoundNBT.m_128365_("PendingSpawns", (Tag)nbttaglist);
    }

    @Override
    public boolean isActive() {
        return this.m_58900_().m_61143_(BlockAlveary.STATE) == BlockAlveary.State.ON;
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActive() != active) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BlockAlveary.STATE, (Comparable)((Object)(active ? BlockAlveary.State.ON : BlockAlveary.State.OFF))));
        }
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerAlvearySwarmer(windowId, inv, this);
    }
}

