/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.climate.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearyHygroregulator;
import forestry.apiculture.inventory.InventoryHygroregulator;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidRecipeFilter;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.RecipeUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileAlvearyHygroregulator
extends TileAlveary
implements Container,
ILiquidTankTile,
IAlvearyComponent.Climatiser<MultiblockLogicAlveary> {
    private final TankManager tankManager;
    private final FilteredTank liquidTank;
    private final IInventoryAdapter inventory = new InventoryHygroregulator(this);
    @Nullable
    private IHygroregulatorRecipe currentRecipe;
    private int heatTicks;

    public TileAlvearyHygroregulator(BlockPos pos, BlockState state) {
        super(BlockAlvearyType.HYGRO, pos, state);
        this.liquidTank = new FilteredTank(10000).setFilter(FluidRecipeFilter.HYGROREGULATOR_INPUT);
        this.tankManager = new TankManager(this, this.liquidTank);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void changeClimate(int tickCount, IClimateControlled climateControlled) {
        FluidStack fluid;
        if (this.heatTicks <= 0 && !(fluid = this.liquidTank.getFluid()).isEmpty()) {
            this.currentRecipe = RecipeUtils.getHygroRegulatorRecipe(this.f_58857_.m_7465_(), fluid);
            if (this.currentRecipe != null) {
                this.liquidTank.drainInternal(this.currentRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.heatTicks = 20;
            }
        }
        if (this.heatTicks > 0) {
            --this.heatTicks;
            if (this.currentRecipe != null) {
                climateControlled.addHumidityChange(this.currentRecipe.getHumiditySteps());
                climateControlled.addTemperatureChange(this.currentRecipe.getTemperatureSteps());
            } else {
                this.heatTicks = 0;
            }
        }
        if (tickCount % 20 == 0) {
            FluidHelper.drainContainers(this.tankManager, this, 0);
        }
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.tankManager.read(compoundNBT);
        this.heatTicks = compoundNBT.m_128451_("TransferTime");
        if (compoundNBT.m_128441_("CurrentLiquid")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((CompoundTag)compoundNBT.m_128469_("CurrentLiquid"));
            this.currentRecipe = RecipeUtils.getHygroRegulatorRecipe(RecipeUtils.getRecipeManager(), liquid);
        }
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.tankManager.write(compoundNBT);
        compoundNBT.m_128405_("TransferTime", this.heatTicks);
        if (this.currentRecipe != null) {
            CompoundTag subcompound = new CompoundTag();
            this.currentRecipe.getInputFluid().writeToNBT(subcompound);
            compoundNBT.m_128365_("CurrentLiquid", (Tag)subcompound);
        }
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> superCap = super.getCapability(capability, facing);
        if (superCap.isPresent()) {
            return superCap;
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerAlvearyHygroregulator(windowId, inv, this);
    }
}

