/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.hives;

import forestry.api.apiculture.hives.IHiveGen;
import forestry.core.utils.BlockUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class HiveGenCaveCeiling
implements IHiveGen {
    private final TagKey<Block> blocks;
    private final TagKey<Block> extraReplaceable;

    public HiveGenCaveCeiling(TagKey<Block> blocks, TagKey<Block> extraReplaceable) {
        this.blocks = blocks;
        this.extraReplaceable = extraReplaceable;
    }

    @Override
    @Nullable
    public BlockPos getPosForHive(WorldGenLevel level, int posX, int posZ) {
        return null;
    }

    @Override
    @Nullable
    public BlockPos getPosForHive(WorldGenLevel level, RandomSource rand, int posX, int posZ) {
        int minBuildHeight;
        int groundY = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, posX, posZ);
        if (groundY == (minBuildHeight = level.m_141937_())) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(posX, groundY, posZ);
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        BlockState blockState = level.m_8055_((BlockPos)pos);
        while (pos.m_123342_() > minBuildHeight) {
            BlockPos bellow;
            if (blockState.m_204336_(this.blocks) && this.canReplace(level.m_8055_(bellow = pos.m_7495_()), level, bellow)) {
                validPos.add(bellow);
            }
            pos.m_122173_(Direction.DOWN);
            blockState = level.m_8055_((BlockPos)pos);
        }
        return !validPos.isEmpty() ? (BlockPos)validPos.get(validPos.size() > 1 ? rand.m_188503_(validPos.size()) : 0) : null;
    }

    @Override
    public boolean isValidLocation(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_204336_(this.blocks);
    }

    @Override
    public boolean canReplace(BlockState blockState, WorldGenLevel level, BlockPos pos) {
        return BlockUtil.canReplace(blockState, (LevelAccessor)level, pos) || blockState.m_204336_(this.extraReplaceable);
    }
}

