/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.hives;

import forestry.api.ForestryTags;
import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.hives.IHiveDefinition;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.core.ToleranceType;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.apiculture.blocks.BlockHiveType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.hives.HiveGenCaveCeiling;
import forestry.apiculture.hives.HiveGenGround;
import forestry.apiculture.hives.HiveGenOcean;
import forestry.apiculture.hives.HiveGenTree;
import forestry.core.utils.SpeciesUtil;
import forestry.modules.features.FeatureBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HiveDefinition implements IHiveDefinition
{
    FOREST(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.FOREST)).defaultState(), 6.0f, ForestryBeeSpecies.FOREST, HiveGenTree.INSTANCE){

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            1.postGenFlowers(level, rand, pos, flowerStates);
        }

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return super.isGoodBiome(biome) && !biome.m_203656_(Tags.Biomes.IS_SNOWY);
        }
    }
    ,
    MEADOWS(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.MEADOWS)).defaultState(), 1.0f, ForestryBeeSpecies.MEADOWS, new HiveGenGround((TagKey<Block>)BlockTags.f_144274_)){

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            2.postGenFlowers(level, rand, pos, flowerStates);
        }

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return super.isGoodBiome(biome) && !biome.m_203656_(BiomeTags.f_207611_);
        }
    }
    ,
    DESERT(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.DESERT)).defaultState(), 1.0f, ForestryBeeSpecies.MODEST, new HiveGenGround(ForestryTags.Blocks.MODEST_BEE_GROUND)){

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            3.postGenFlowers(level, rand, pos, cactusStates);
        }
    }
    ,
    JUNGLE(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.JUNGLE)).defaultState(), 6.0f, ForestryBeeSpecies.TROPICAL, HiveGenTree.INSTANCE),
    END(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.END)).defaultState(), 2.0f, ForestryBeeSpecies.ENDED, new HiveGenGround(ForestryTags.Blocks.ENDED_BEE_GROUND)){

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return biome.m_203656_(BiomeTags.f_215818_);
        }
    }
    ,
    SNOW(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.SNOW)).defaultState(), 2.0f, ForestryBeeSpecies.WINTRY, new HiveGenGround(ForestryTags.Blocks.WINTRY_BEE_GROUND)){

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            BlockPos posAbove = pos.m_7494_();
            if (level.m_46859_(posAbove)) {
                level.m_7731_(posAbove, Blocks.f_50125_.m_49966_(), 2);
            }
            5.postGenFlowers(level, rand, pos, flowerStates);
        }
    }
    ,
    SWAMP(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.SWAMP)).defaultState(), 2.0f, ForestryBeeSpecies.MARSHY, new HiveGenGround((TagKey<Block>)BlockTags.f_144274_)){

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            6.postGenFlowers(level, rand, pos, mushroomStates);
        }

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return super.isGoodBiome(biome) && !biome.m_203656_(Tags.Biomes.IS_SNOWY);
        }
    }
    ,
    SAVANNA(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.SAVANNA)).defaultState(), 1.0f, ForestryBeeSpecies.SAVANNA, new HiveGenGround((TagKey<Block>)BlockTags.f_144274_)){

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
        }
    }
    ,
    LUSH(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.LUSH)).defaultState(), 2.0f, ForestryBeeSpecies.LUSH, new HiveGenCaveCeiling(ForestryTags.Blocks.LUSH_BEE_CEILING, ForestryTags.Blocks.CAVE_EXTRA_REPLACEABLES)){

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return super.isGoodBiome(biome) && biome.m_203656_(Tags.Biomes.IS_CAVE);
        }

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            if (level.m_8055_(pos.m_7495_()).m_247087_()) {
                level.m_7731_(pos.m_7495_(), (BlockState)Blocks.f_152538_.m_49966_().m_61124_((Property)BlockStateProperties.f_155977_, (Comparable)Boolean.valueOf(rand.m_188501_() < 0.11f)), 2);
            }
        }
    }
    ,
    AQUATIC(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.AQUATIC)).defaultState(), 1.0f, ForestryBeeSpecies.AQUATIC, new HiveGenOcean((TagKey<Block>)BlockTags.f_13029_)){
        static final Block[] CORAL_FANS = new Block[]{Blocks.f_50565_, Blocks.f_50563_, Blocks.f_50564_, Blocks.f_50566_, Blocks.f_50562_};
        static final Block[] CORAL_PLANTS = new Block[]{Blocks.f_50555_, Blocks.f_50553_, Blocks.f_50554_, Blocks.f_50556_, Blocks.f_50552_};

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return biome.m_203565_(Biomes.f_48166_);
        }

        @Override
        public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
            for (Direction direction : Direction.f_122346_) {
                BlockPos pos2 = pos.m_121945_(direction);
                if (direction.m_122434_().m_122479_() && level.m_8055_(pos2).m_60734_() == Blocks.f_49990_) {
                    level.m_7731_(pos2, (BlockState)CORAL_FANS[rand.m_188503_(5)].m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction), 2);
                }
                if (level.m_8055_(pos.m_7494_()).m_60734_() != Blocks.f_49990_) continue;
                level.m_7731_(pos.m_7494_(), CORAL_PLANTS[rand.m_188503_(5)].m_49966_(), 2);
            }
        }
    }
    ,
    NETHER(((FeatureBlock)ApicultureBlocks.BEEHIVE.get(BlockHiveType.NETHER)).defaultState(), 4.0f, ForestryBeeSpecies.EMBITTERED, new HiveGenCaveCeiling((TagKey<Block>)BlockTags.f_13078_, ForestryTags.Blocks.NETHER_EXTRA_REPLACEABLES)){

        @Override
        public boolean isGoodBiome(Holder<Biome> biome) {
            return biome.m_203656_(BiomeTags.f_207612_);
        }
    };

    private static final IHiveGen FLOWER_GROUND;
    private static final List<BlockState> flowerStates;
    private static final List<BlockState> mushroomStates;
    private static final List<BlockState> cactusStates;
    private final BlockState blockState;
    private final float genChance;
    private final ResourceLocation speciesId;
    private final IHiveGen hiveGen;

    private HiveDefinition(BlockState hiveState, float genChance, ResourceLocation beeTemplate, IHiveGen hiveGen) {
        this.blockState = hiveState;
        this.genChance = genChance;
        this.speciesId = beeTemplate;
        this.hiveGen = hiveGen;
    }

    @Override
    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public boolean isGoodBiome(Holder<Biome> biome) {
        return !biome.m_203656_(BiomeTags.f_207612_);
    }

    @Override
    public boolean isGoodHumidity(HumidityType humidity) {
        IBeeSpecies species = SpeciesUtil.getBeeSpecies(this.speciesId);
        HumidityType idealHumidity = species.getHumidity();
        ToleranceType humidityTolerance = species.getDefaultGenome().getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE);
        return ClimateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    @Override
    public boolean isGoodTemperature(TemperatureType temperature) {
        IBeeSpecies species = SpeciesUtil.getBeeSpecies(this.speciesId);
        TemperatureType idealTemperature = species.getTemperature();
        ToleranceType temperatureTolerance = species.getDefaultGenome().getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE);
        return ClimateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    @Override
    public float getGenChance() {
        return this.genChance;
    }

    @Override
    public void postGen(WorldGenLevel level, RandomSource rand, BlockPos pos) {
    }

    protected static void postGenFlowers(WorldGenLevel world, RandomSource rand, BlockPos hivePos, List<BlockState> flowerStates) {
        int plantedCount = 0;
        for (int i = 0; i < 10; ++i) {
            BlockState state;
            Block block;
            int xOffset = rand.m_188503_(8) - 4;
            int zOffset = rand.m_188503_(8) - 4;
            BlockPos blockPos = hivePos.m_7918_(xOffset, 0, zOffset);
            if (xOffset == 0 && zOffset == 0 || !world.m_46805_(blockPos) || (blockPos = FLOWER_GROUND.getPosForHive(world, blockPos.m_123341_(), blockPos.m_123343_())) == null || !(block = (state = flowerStates.get(rand.m_188503_(flowerStates.size()))).m_60734_()).m_49966_().m_60710_((LevelReader)world, blockPos)) continue;
            world.m_7731_(blockPos, state, 2);
            if (++plantedCount >= 3) break;
        }
    }

    static {
        FLOWER_GROUND = new HiveGenGround(ForestryTags.Blocks.PLANTABLE_FLOWERS_GROUND);
        flowerStates = new ArrayList<BlockState>();
        mushroomStates = new ArrayList<BlockState>();
        cactusStates = Collections.singletonList(Blocks.f_50128_.m_49966_());
        flowerStates.addAll((Collection<BlockState>)Blocks.f_50112_.m_49965_().m_61056_());
        flowerStates.addAll((Collection<BlockState>)Blocks.f_50111_.m_49965_().m_61056_());
        mushroomStates.add(Blocks.f_50073_.m_49966_());
        mushroomStates.add(Blocks.f_50072_.m_49966_());
    }
}

