/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.network.packets.PacketAlvearyChange;
import forestry.core.blocks.BlockStructure;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockAlveary
extends BlockStructure
implements EntityBlock {
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);
    private static final EnumProperty<AlvearyPlainType> PLAIN_TYPE = EnumProperty.m_61587_((String)"type", AlvearyPlainType.class);
    private final BlockAlvearyType type;

    public BlockAlveary(BlockAlvearyType type) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60918_(SoundType.f_56736_));
        this.type = type;
        BlockState defaultState = (BlockState)this.m_49965_().m_61090_();
        if (type == BlockAlvearyType.PLAIN) {
            defaultState = (BlockState)defaultState.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
        } else if (type.activatable) {
            defaultState = (BlockState)defaultState.m_61124_(STATE, (Comparable)((Object)State.OFF));
        }
        this.m_49959_(defaultState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PLAIN_TYPE, STATE});
    }

    public BlockAlvearyType getType() {
        return this.type;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.type) {
            case BlockAlvearyType.SWARMER -> new TileAlvearySwarmer(pos, state);
            case BlockAlvearyType.FAN -> new TileAlvearyFan(pos, state);
            case BlockAlvearyType.HEATER -> new TileAlvearyHeater(pos, state);
            case BlockAlvearyType.HYGRO -> new TileAlvearyHygroregulator(pos, state);
            case BlockAlvearyType.STABILISER -> new TileAlvearyStabiliser(pos, state);
            case BlockAlvearyType.SIEVE -> new TileAlvearySieve(pos, state);
            default -> new TileAlvearyPlain(pos, state);
        };
    }

    public BlockState getNewState(TileAlveary tile) {
        BlockState state = this.m_49966_();
        if (tile instanceof IActivatable) {
            IActivatable activatable = (IActivatable)((Object)tile);
            state = (BlockState)state.m_61124_(STATE, (Comparable)((Object)(activatable.isActive() ? State.ON : State.OFF)));
        } else if (this.getType() == BlockAlvearyType.PLAIN) {
            Level level = tile.m_58904_();
            BlockPos pos = tile.m_58899_();
            if (!((MultiblockLogicAlveary)tile.getMultiblockLogic()).getController().isAssembled()) {
                state = (BlockState)state.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
            } else {
                BlockState blockStateAbove = level.m_8055_(pos.m_7494_());
                if (blockStateAbove.m_204336_(BlockTags.f_13097_)) {
                    List<Direction> blocksTouching = BlockAlveary.getBlocksTouching((BlockGetter)level, pos);
                    switch (blocksTouching.size()) {
                        case 3: {
                            state = (BlockState)state.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE));
                            break;
                        }
                        case 2: {
                            if (blocksTouching.contains(Direction.SOUTH) && blocksTouching.contains(Direction.EAST) || blocksTouching.contains(Direction.NORTH) && blocksTouching.contains(Direction.WEST)) {
                                state = (BlockState)state.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE_LEFT));
                                break;
                            }
                            state = (BlockState)state.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE_RIGHT));
                            break;
                        }
                        default: {
                            state = (BlockState)state.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
                            break;
                        }
                    }
                } else {
                    state = (BlockState)state.m_61124_(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
                }
            }
        }
        return state;
    }

    private static List<Direction> getBlocksTouching(BlockGetter world, BlockPos blockPos) {
        ArrayList<Direction> touching = new ArrayList<Direction>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockState = world.m_8055_(blockPos.m_121945_(direction));
            if (!(blockState.m_60734_() instanceof BlockAlveary)) continue;
            touching.add(direction);
        }
        return touching;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        TileUtil.actOnTile((LevelReader)worldIn, pos, TileAlveary.class, tileAlveary -> {
            IAlvearyControllerInternal alveary = ((MultiblockLogicAlveary)tileAlveary.getMultiblockLogic()).getController();
            alveary.reassemble();
            BlockPos referenceCoord = alveary.getReferenceCoord();
            NetworkUtil.sendNetworkPacket(new PacketAlvearyChange(referenceCoord), referenceCoord, worldIn);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"block.forestry.alveary_tooltip"));
        } else {
            ItemTooltipUtil.addShiftInformation(stack, world, tooltip, flag);
        }
    }

    private static enum AlvearyPlainType implements StringRepresentable
    {
        NORMAL,
        ENTRANCE,
        ENTRANCE_LEFT,
        ENTRANCE_RIGHT;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum State implements StringRepresentable
    {
        ON,
        OFF;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

