/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.util.TickHelper;
import forestry.apiculture.HasFlowersCache;
import forestry.apiculture.network.packets.PacketBeeLogicActive;
import forestry.apiculture.tiles.TileHive;
import forestry.core.utils.NetworkUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldgenBeekeepingLogic
implements IBeekeepingLogic {
    private final TileHive housing;
    private final IEffectData[] effectData = new IEffectData[2];
    private final HasFlowersCache hasFlowersCache = new HasFlowersCache(2);
    private final TickHelper tickHelper;
    private boolean active;

    public WorldgenBeekeepingLogic(TileHive housing) {
        this.housing = housing;
        this.tickHelper = new TickHelper(housing.m_58899_().hashCode());
    }

    @Override
    public void read(CompoundTag CompoundNBT) {
        this.setActive(CompoundNBT.m_128471_("Active"));
        this.hasFlowersCache.read(CompoundNBT);
    }

    @Override
    public CompoundTag write(CompoundTag CompoundNBT) {
        CompoundNBT.m_128379_("Active", this.active);
        this.hasFlowersCache.write(CompoundNBT);
        return CompoundNBT;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.writeBoolean(this.active);
        if (this.active) {
            this.hasFlowersCache.writeData(data);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        boolean active = data.readBoolean();
        this.setActive(active);
        if (active) {
            this.hasFlowersCache.readData(data);
        }
    }

    private void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncToClient();
    }

    @Override
    public boolean canWork() {
        this.tickHelper.onTick();
        if (this.tickHelper.updateOnInterval(200)) {
            IBee queen = this.housing.getContainedBee();
            this.hasFlowersCache.update(queen, this.housing);
            Level level = this.housing.getWorldObj();
            IGenome genome = queen.getGenome();
            boolean canWork = genome.getActiveValue(BeeChromosomes.ACTIVITY).isActive(level.m_46467_(), level.m_46468_(), this.housing.m_58899_()) && (!this.housing.isRaining() || genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN));
            boolean flowerCacheNeedsSync = this.hasFlowersCache.needsSync();
            if (this.active != canWork) {
                this.setActive(canWork);
            } else if (flowerCacheNeedsSync) {
                this.syncToClient();
            }
        }
        return this.active;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void clearCachedValues() {
    }

    @Override
    public void syncToClient() {
        Level world = this.housing.getWorldObj();
        if (world != null && !world.f_46443_) {
            NetworkUtil.sendNetworkPacket(new PacketBeeLogicActive(this.housing), this.housing.getCoordinates(), world);
        }
    }

    @Override
    public void syncToClient(ServerPlayer player) {
        Level world = this.housing.getWorldObj();
        if (world != null && !world.f_46443_) {
            NetworkUtil.sendToPlayer(new PacketBeeLogicActive(this.housing), player);
        }
    }

    @Override
    public int getBeeProgressPercent() {
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canDoBeeFX() {
        return !Minecraft.m_91087_().m_91104_() && this.active;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doBeeFX() {
        IBee queen = this.housing.getContainedBee();
        queen.doFX(this.effectData, this.housing);
    }

    @Override
    public List<BlockPos> getFlowerPositions() {
        return this.hasFlowersCache.getFlowerCoords();
    }
}

