/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.plugin;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableFactory;
import forestry.api.farming.IWaterConsumption;
import forestry.api.plugin.IWindfallFarmableBuilder;
import it.unimi.dsi.fastutil.floats.Float2IntFunction;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface IFarmTypeBuilder {
    public IFarmTypeBuilder setIcon(ItemStack var1);

    public IFarmTypeBuilder setLogicFactory(BiFunction<IFarmType, Boolean, IFarmLogic> var1);

    default public IFarmTypeBuilder setFertilizerConsumption(int consumption) {
        return this.setFertilizerConsumption(housing -> consumption);
    }

    public IFarmTypeBuilder setFertilizerConsumption(ToIntFunction<IFarmHousing> var1);

    default public IFarmTypeBuilder setWaterConsumption(int waterConsumption) {
        return this.setWaterConsumption((IFarmHousing housing, float hydrationModifier) -> waterConsumption);
    }

    default public IFarmTypeBuilder setWaterConsumption(Float2IntFunction waterConsumption) {
        return this.setWaterConsumption((IFarmHousing housing, float hydrationModifier) -> waterConsumption.get(hydrationModifier));
    }

    public IFarmTypeBuilder setWaterConsumption(IWaterConsumption var1);

    default public IFarmTypeBuilder addSoil(Block block) {
        return this.addSoil(new ItemStack((ItemLike)block), block.m_49966_());
    }

    public IFarmTypeBuilder addSoil(ItemStack var1, BlockState var2);

    public IFarmTypeBuilder addGermling(ItemStack var1);

    public IFarmTypeBuilder addGermlings(Iterable<ItemStack> var1);

    public IFarmTypeBuilder addProduct(ItemStack var1);

    public IFarmTypeBuilder addProducts(Collection<ItemStack> var1);

    public IFarmTypeBuilder addFarmable(IFarmable var1);

    public IFarmTypeBuilder addWindfallFarmable(Item var1, IFarmableFactory var2, Consumer<IWindfallFarmableBuilder> var3);

    public IFarmTypeBuilder modifyWindfallFarmable(Item var1, Consumer<IWindfallFarmableBuilder> var2);
}

