/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics.alleles;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.plugin.IGenomeBuilder;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;

public interface IKaryotype {
    public ImmutableList<IChromosome<?>> getChromosomes();

    public boolean contains(IChromosome<?> var1);

    public IRegistryChromosome<? extends ISpecies<?>> getSpeciesChromosome();

    public int size();

    public <A extends IAllele> boolean isChromosomeValid(IChromosome<A> var1);

    public <A extends IAllele> A getDefaultAllele(IChromosome<A> var1);

    public boolean isWeaklyInherited(IChromosome<?> var1);

    public ResourceLocation getDefaultSpecies();

    public <A extends IAllele> boolean isAlleleValid(IChromosome<A> var1, A var2);

    public Codec<IGenome> getGenomeCodec();

    public ImmutableMap<IChromosome<?>, ? extends IAllele> getDefaultAlleles();

    public IGenomeBuilder createGenomeBuilder();

    public <A extends IAllele> Collection<A> getAlleles(IChromosome<A> var1);
}

