/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import codechicken.microblock.api.MicroMaterial;
import com.mojang.serialization.Codec;
import mrtjp.projectred.exploration.data.ExplorationBlockStateModelProvider;
import mrtjp.projectred.exploration.data.ExplorationBlockTagsProvider;
import mrtjp.projectred.exploration.data.ExplorationBuiltInEntriesProvider;
import mrtjp.projectred.exploration.data.ExplorationItemModelProvider;
import mrtjp.projectred.exploration.data.ExplorationItemTagsProvider;
import mrtjp.projectred.exploration.data.ExplorationLanguageProvider;
import mrtjp.projectred.exploration.data.ExplorationLootTableProvider;
import mrtjp.projectred.exploration.data.ExplorationRecipeProvider;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.init.ExplorationClientInit;
import mrtjp.projectred.exploration.init.ExplorationCreativeModeTabs;
import mrtjp.projectred.exploration.init.ExplorationItems;
import mrtjp.projectred.exploration.init.ExplorationMenus;
import mrtjp.projectred.exploration.init.ExplorationRecipeSerializers;
import mrtjp.projectred.exploration.init.ExplorationWorldFeatures;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="projectred_exploration")
public class ProjectRedExploration {
    public static final String MOD_ID = "projectred_exploration";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred_exploration");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_exploration");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"projectred_exploration");
    public static final DeferredRegister<WorldCarver<?>> WORLD_CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)"projectred_exploration");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"projectred_exploration");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"projectred_exploration");
    public static final DeferredRegister<MicroMaterial> MICRO_MATERIALS = DeferredRegister.create((ResourceLocation)new ResourceLocation("cb_microblock", "micro_material"), (String)"projectred_exploration");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"projectred_exploration");

    public ProjectRedExploration() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        modEventBus.addListener(ExplorationBlocks::onRegisterMicroMaterials);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ExplorationClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        WORLD_CARVERS.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        MICRO_MATERIALS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ExplorationBlockStateModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExplorationItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExplorationLanguageProvider(output));
        ExplorationBuiltInEntriesProvider explorationProvider = new ExplorationBuiltInEntriesProvider(output, event.getLookupProvider());
        generator.addProvider(event.includeServer(), (DataProvider)explorationProvider);
        ExplorationBlockTagsProvider blockTagsProvider = new ExplorationBlockTagsProvider(output, event.getLookupProvider(), fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ExplorationItemTagsProvider(output, event.getLookupProvider(), blockTagsProvider.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExplorationLootTableProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ExplorationRecipeProvider(output));
    }

    static {
        ExplorationBlocks.register();
        ExplorationItems.register();
        ExplorationMenus.register();
        ExplorationWorldFeatures.register();
        ExplorationRecipeSerializers.register();
        ExplorationCreativeModeTabs.register();
    }
}

