/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.network.node.SecurityManagerNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.SecurityManagerBlockEntity;
import com.refinedmods.refinedstorage.container.SecurityManagerContainerMenu;
import com.refinedmods.refinedstorage.item.SecurityCardItem;
import com.refinedmods.refinedstorage.network.SecurityManagerUpdateMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class SecurityManagerScreen
extends BaseScreen<SecurityManagerContainerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/security_manager.png");
    private final SecurityManagerBlockEntity securityManager;
    private final CheckboxWidget[] permissions = new CheckboxWidget[Permission.values().length];

    public SecurityManagerScreen(SecurityManagerContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 176, 234, inventory, title);
        this.securityManager = (SecurityManagerBlockEntity)containerMenu.getBlockEntity();
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, NetworkNodeBlockEntity.REDSTONE_MODE));
        int padding = 15;
        this.permissions[0] = this.addCheckBox(x + 7, y + 93, (Component)Component.m_237115_((String)"gui.refinedstorage.security_manager.permission.0"), false, btn -> this.handle(0));
        this.permissions[1] = this.addCheckBox(this.permissions[0].m_252754_(), this.permissions[0].m_252907_() + padding, (Component)Component.m_237115_((String)"gui.refinedstorage.security_manager.permission.1"), false, btn -> this.handle(1));
        this.permissions[2] = this.addCheckBox(this.permissions[1].m_252754_(), this.permissions[1].m_252907_() + padding, (Component)Component.m_237115_((String)"gui.refinedstorage.security_manager.permission.2"), false, btn -> this.handle(2));
        this.permissions[3] = this.addCheckBox(this.permissions[0].m_252754_() + 90, this.permissions[0].m_252907_(), (Component)Component.m_237115_((String)"gui.refinedstorage.security_manager.permission.3"), false, btn -> this.handle(3));
        this.permissions[4] = this.addCheckBox(this.permissions[3].m_252754_(), this.permissions[3].m_252907_() + padding, (Component)Component.m_237115_((String)"gui.refinedstorage.security_manager.permission.4"), false, btn -> this.handle(4));
        this.permissions[5] = this.addCheckBox(this.permissions[4].m_252754_(), this.permissions[4].m_252907_() + padding, (Component)Component.m_237115_((String)"gui.refinedstorage.security_manager.permission.5"), false, btn -> this.handle(5));
    }

    private void handle(int i) {
        RS.NETWORK_HANDLER.sendToServer(new SecurityManagerUpdateMessage(this.securityManager.m_58899_(), Permission.values()[i], this.permissions[i].m_93840_()));
    }

    @Override
    public void tick(int x, int y) {
        ItemStack card = ((SecurityManagerNetworkNode)this.securityManager.getNode()).getEditCard().getStackInSlot(0);
        for (Permission permission : Permission.values()) {
            this.permissions[permission.getId()].setChecked(!card.m_41619_() && SecurityCardItem.hasPermission(card, permission));
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        this.renderString(graphics, 7, 59, I18n.m_118938_((String)"gui.refinedstorage.security_manager.configure", (Object[])new Object[0]));
        this.renderString(graphics, 7, 140, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        for (int i = 0; i < this.permissions.length; ++i) {
            CheckboxWidget permission = this.permissions[i];
            if (!RenderUtils.inBounds(permission.m_252754_() - this.f_97735_, permission.m_252907_() - this.f_97736_, permission.m_5711_(), permission.m_93694_(), mouseX, mouseY)) continue;
            this.renderTooltip(graphics, mouseX, mouseY, I18n.m_118938_((String)("gui.refinedstorage.security_manager.permission." + i + ".tooltip"), (Object[])new Object[0]));
        }
    }
}

