/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.tooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PositionAwareTooltipComponent;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PreviewTooltipData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class PreviewTooltipComponent
extends PositionAwareTooltipComponent {
    private final PreviewRenderer renderer;
    private final PreviewProvider provider;
    private final PreviewContext context;

    public PreviewTooltipComponent(PreviewTooltipData data) {
        PreviewRenderer renderer = data.provider().getRenderer();
        if (renderer == null) {
            renderer = PreviewRenderer.getDefaultRendererInstance();
        }
        this.renderer = renderer;
        this.provider = data.provider();
        this.context = data.context();
    }

    public int m_142103_() {
        if (ShulkerBoxTooltip.config.preview.position == Configuration.PreviewPosition.INSIDE) {
            return this.renderer.getHeight() + 2 + 4;
        }
        return 0;
    }

    public int m_142069_(Font textRenderer) {
        if (ShulkerBoxTooltip.config.preview.position == Configuration.PreviewPosition.INSIDE) {
            return this.renderer.getWidth() + 2;
        }
        return 0;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        this.prepareRenderer();
        this.drawAt(x, y, context, textRenderer, 0, 0);
    }

    @Override
    public void drawItemsWithTooltipPosition(Font textRenderer, int x, int y, GuiGraphics context, int tooltipTopY, int tooltipBottomY, int mouseX, int mouseY) {
        Configuration.PreviewPosition position = ShulkerBoxTooltip.config.preview.position;
        this.prepareRenderer();
        if (position != Configuration.PreviewPosition.INSIDE) {
            int h = this.renderer.getHeight();
            int w = this.renderer.getWidth();
            int screenW = context.m_280182_();
            int screenH = context.m_280206_();
            x = Math.min(x - 4, screenW - w);
            y = tooltipBottomY;
            if (position == Configuration.PreviewPosition.OUTSIDE_TOP || position == Configuration.PreviewPosition.OUTSIDE && y + h > screenH) {
                y = tooltipTopY - h;
            }
        }
        this.drawAt(x, y, context, textRenderer, mouseX, mouseY);
    }

    private void prepareRenderer() {
        this.renderer.setPreview(this.context, this.provider);
        this.renderer.setPreviewType(ShulkerBoxTooltipApi.getCurrentPreviewType(this.provider.isFullPreviewAvailable(this.context)));
    }

    private void drawAt(int x, int y, GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
        this.renderer.draw(x, y, context, textRenderer, mouseX, mouseY);
    }
}

