/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicInteger;
import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class FactoryGenerator {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final MixinCompiler compiler;

    public FactoryGenerator(MixinCompiler compiler) {
        this.compiler = compiler;
    }

    public Method findMethod(Class<?> clazz) {
        if (!clazz.isInterface()) {
            throw new RuntimeException("Class is not an interface.");
        }
        Object[] methods = (Method[])FastStream.of((Object[])clazz.getMethods()).filter(e -> !Modifier.isStatic(e.getModifiers())).filter(e -> Modifier.isAbstract(e.getModifiers())).toArray((Object[])new Method[0]);
        if (methods.length == 0) {
            throw new IllegalArgumentException("No implementable methods found for class: " + clazz.getName());
        }
        if (methods.length > 1) {
            String names = FastStream.of((Object[])methods).map(Method::getName).join(",");
            throw new IllegalStateException("Multiple implementable methods found. [" + names + "] in " + clazz.getName());
        }
        return methods[0];
    }

    public <T, F> F generateFactory(Class<T> actualClass, Class<F> factoryClazz) {
        Method factoryMethod = this.findMethod(factoryClazz);
        if (Utils.findConstructor(actualClass, factoryMethod.getParameterTypes()) == null) {
            throw new IllegalArgumentException("Unable to find constructor for " + actualClass.getName() + " that matches Factory method in " + factoryClazz.getName());
        }
        ClassWriter cw = new ClassWriter(3);
        String cName = actualClass.getName().replace('.', '/') + "$$Ctor$$" + COUNTER.getAndIncrement();
        cw.visit(52, 4145, cName, null, Utils.asmName(Object.class), new String[]{Utils.asmName(factoryClazz)});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Utils.asmName(Object.class), "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        Type factoryType = Type.getType((Method)factoryMethod);
        Type[] params = factoryType.getArgumentTypes();
        mv = cw.visitMethod(1, factoryMethod.getName(), factoryType.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Utils.asmName(actualClass));
        mv.visitInsn(89);
        int count = 1;
        for (Type param : params) {
            mv.visitVarInsn(param.getOpcode(21), count);
            count += param.getSort() == 8 || param.getSort() == 7 ? 2 : 1;
        }
        mv.visitMethodInsn(183, Utils.asmName(actualClass), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])params), false);
        mv.visitTypeInsn(192, Utils.asmName(factoryType.getReturnType().getInternalName()));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        Class factory = this.compiler.defineClass(cName, bytes);
        try {
            return (F)factory.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to instantiate new factory.", ex);
        }
    }
}

