/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import java.io.IOException;
import java.io.InputStream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public interface MixinBackend {
    public ClassLoader getContextClassLoader();

    public byte @Nullable [] getBytes(String var1);

    default public boolean filterMethodAnnotations(String annType, String value) {
        return true;
    }

    public static class SimpleMixinBackend
    implements MixinBackend {
        private final ClassLoader classLoader;

        public SimpleMixinBackend() {
            this(SimpleMixinBackend.class.getClassLoader());
        }

        public SimpleMixinBackend(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader getContextClassLoader() {
            return this.classLoader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte @Nullable [] getBytes(String name) {
            try (InputStream is = this.classLoader.getResourceAsStream(name + ".class");){
                if (is == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byte[] byArray = IOUtils.toBytes((InputStream)is);
                return byArray;
            }
            catch (IOException e) {
                SneakyUtils.throwUnchecked((Throwable)new ClassNotFoundException("Could not load bytes for '" + name + "'.", e));
                return null;
            }
        }
    }
}

