/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.item.Crowbar;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.client.ScreenFactories;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EmbarkingTrackBlock
extends PoweredOutfittedTrackBlock {
    public static final short TELEPORT_PARTICLES = 64;
    public static final int MIN_RADIUS = 1;
    public static final int MAX_RADIUS = 5;
    public static final Set<EntityType<?>> excludedEntities = new HashSet();
    public static final IntegerProperty RADIUS;

    public EmbarkingTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{RADIUS});
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(2));
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack) {
        if (level.m_5776_()) {
            ScreenFactories.openEmbarkingTrackScreen(blockState, blockPos);
        }
        return true;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos blockPos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, blockPos, cart);
        RollingStock extension = RollingStock.getOrThrow(cart);
        if (EmbarkingTrackBlock.isPowered(blockState) && cart.canBeRidden() && !cart.m_20160_() && extension.isMountable()) {
            int radius = EmbarkingTrackBlock.getRadius(blockState);
            AABB box = BoxBuilder.create().at(blockPos).build();
            List entities = level.m_45976_(LivingEntity.class, box = box.m_82377_((double)radius, (double)radius, (double)radius));
            if (!entities.isEmpty()) {
                LivingEntity entity = (LivingEntity)entities.get(level.m_213780_().m_188503_(entities.size()));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.m_6047_()) {
                        return;
                    }
                    ItemStack current = player.m_21205_();
                    if (!current.m_41619_() && current.m_41720_() instanceof Crowbar) {
                        return;
                    }
                } else {
                    Slime slime;
                    if (excludedEntities.contains(entity.m_6095_()) || entity instanceof WaterAnimal) {
                        return;
                    }
                    if (entity instanceof Slime && (slime = (Slime)entity).m_33632_() >= 100) {
                        return;
                    }
                }
                if (!entity.m_20159_()) {
                    EmbarkingTrackBlock.teleportEffect((Entity)entity, cart.m_20182_());
                    entity.m_20329_((Entity)cart);
                }
            }
        }
    }

    private static void teleportEffect(Entity entity, Vec3 destination) {
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        RandomSource random = level.m_213780_();
        Vec3 start = entity.m_20182_();
        for (int i = 0; i < 64; ++i) {
            double travel = (double)i / 63.0;
            float vX = (random.m_188501_() - 0.5f) * 0.2f;
            float vY = (random.m_188501_() - 0.5f) * 0.2f;
            float vZ = (random.m_188501_() - 0.5f) * 0.2f;
            double pX = start.f_82479_ + (destination.f_82479_ - start.f_82479_) * travel + (random.m_188500_() - 0.5) * 2.0;
            double pY = start.f_82480_ + (destination.f_82480_ - start.f_82480_) * travel + (random.m_188500_() - 0.5) * 2.0;
            double pZ = start.f_82481_ + (destination.f_82481_ - start.f_82481_) * travel + (random.m_188500_() - 0.5) * 2.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, pX, pY, pZ, (double)vX, (double)vY, (double)vZ);
        }
        level.m_6269_(null, entity, SoundEvents.f_11852_, SoundSource.BLOCKS, 0.25f, 1.0f);
    }

    public static int getRadius(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)RADIUS);
    }

    public static BlockState setRadius(BlockState blockState, int radius) {
        return (BlockState)blockState.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(Mth.m_14045_((int)radius, (int)1, (int)5)));
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.EMBARKING_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_RANGE).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).m_130940_(ChatFormatting.RED));
    }

    static {
        excludedEntities.add(EntityType.f_20460_);
        excludedEntities.add(EntityType.f_20565_);
        excludedEntities.add(EntityType.f_20496_);
        excludedEntities.add(EntityType.f_20551_);
        excludedEntities.add(EntityType.f_20468_);
        excludedEntities.add(EntityType.f_20480_);
        excludedEntities.add(EntityType.f_20549_);
        RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)5);
    }
}

