/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.actuator;

import mods.railcraft.api.track.ArrowDirection;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SwitchTrackActuatorBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<ArrowDirection> RED_ARROW_DIRECTION = EnumProperty.m_61587_((String)"red_flag", ArrowDirection.class);
    public static final EnumProperty<ArrowDirection> WHITE_ARROW_DIRECTION = EnumProperty.m_61587_((String)"white_flag", ArrowDirection.class);
    public static final BooleanProperty SWITCHED = BooleanProperty.m_61465_((String)"switched");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape BASE_SHAPE = SwitchTrackActuatorBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    private static final VoxelShape POST_SHAPE = SwitchTrackActuatorBlock.m_49796_((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0);
    private static final VoxelShape NORTH_SOUTH_WINGS_SHAPE = SwitchTrackActuatorBlock.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)3.0, (double)16.0);
    private static final VoxelShape EAST_WEST_WINGS_SHAPE = SwitchTrackActuatorBlock.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)3.0, (double)10.0);
    private static final VoxelShape NORTH_SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{NORTH_SOUTH_WINGS_SHAPE, POST_SHAPE});
    private static final VoxelShape EAST_WEST_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{EAST_WEST_WINGS_SHAPE, POST_SHAPE});

    public SwitchTrackActuatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(RED_ARROW_DIRECTION, (Comparable)((Object)ArrowDirection.NORTH_SOUTH))).m_61124_(WHITE_ARROW_DIRECTION, (Comparable)((Object)ArrowDirection.EAST_WEST))).m_61124_((Property)SWITCHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, RED_ARROW_DIRECTION, WHITE_ARROW_DIRECTION, SWITCHED, WATERLOGGED});
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidState = level.m_6425_(pos);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_122557_().filter(side -> level.m_8055_(pos.m_121945_(side)).m_60734_() instanceof SwitchTrackBlock).findFirst().orElse(context.m_8125_().m_122424_()))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return level.m_8055_(newPos).m_60734_() instanceof SwitchTrackBlock ? (BlockState)state.m_61124_((Property)f_54117_, (Comparable)direction) : state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.Z ? NORTH_SOUTH_SHAPE : EAST_WEST_SHAPE;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return SwitchTrackActuatorBlock.isSwitched(state) ? 15 : 0;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return SwitchTrackActuatorBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    public static boolean isSwitched(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)SWITCHED);
    }

    public static void setSwitched(BlockState blockState, Level level, BlockPos blockPos, boolean switched) {
        if ((Boolean)blockState.m_61143_((Property)SWITCHED) == switched) {
            return;
        }
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)SWITCHED, (Comparable)Boolean.valueOf(switched)));
        level.m_5594_(null, blockPos, switched ? SoundEvents.f_12311_ : SoundEvents.f_12312_, SoundSource.BLOCKS, 0.25f, level.m_213780_().m_188501_() * 0.25f + 0.7f);
        Direction.Plane.HORIZONTAL.forEach(direction -> {
            BlockPos neighborPos = blockPos.m_121945_(direction);
            if (level.m_8055_(neighborPos).m_60734_() instanceof ComparatorBlock) {
                level.m_46672_(neighborPos, blockState.m_60734_());
            }
        });
    }

    public static ArrowDirection getRedArrowDirection(BlockState blockState) {
        return (ArrowDirection)((Object)blockState.m_61143_(RED_ARROW_DIRECTION));
    }

    public static ArrowDirection getWhiteArrowDirection(BlockState blockState) {
        return (ArrowDirection)((Object)blockState.m_61143_(WHITE_ARROW_DIRECTION));
    }

    public static void updateArrowDirections(BlockState blockState, Level level, BlockPos blockPos, ArrowDirection redArrowDirection, ArrowDirection whiteArrowDirection) {
        BlockState newState = blockState;
        boolean changed = false;
        if (SwitchTrackActuatorBlock.getRedArrowDirection(blockState) != redArrowDirection) {
            newState = (BlockState)newState.m_61124_(RED_ARROW_DIRECTION, (Comparable)((Object)redArrowDirection));
            changed = true;
        }
        if (SwitchTrackActuatorBlock.getWhiteArrowDirection(blockState) != whiteArrowDirection) {
            newState = (BlockState)newState.m_61124_(WHITE_ARROW_DIRECTION, (Comparable)((Object)whiteArrowDirection));
            changed = true;
        }
        if (changed) {
            level.m_46597_(blockPos, newState);
        }
    }
}

