/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.tank;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.inventory.TankMenu;
import mods.railcraft.world.level.block.AbstractStrengthenedGlassBlock;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.level.block.entity.tank.ValveFluidHandler;
import mods.railcraft.world.level.block.tank.TankGaugeBlock;
import mods.railcraft.world.level.block.tank.TankValveBlock;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.TankModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public abstract class TankBlockEntity
extends MultiblockBlockEntity<TankBlockEntity, Void> {
    private static final int FLOW_RATE = 1000;
    private final TankModule module;
    private int lastLight = -1;
    private int maxX;
    private int maxY;
    private int maxZ;
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.empty();

    public TankBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, Collection<MultiblockPattern<Void>> patterns) {
        super(type, blockPos, blockState, TankBlockEntity.class, patterns);
        this.module = this.moduleDispatcher.registerModule("tank", new TankModule(this, StandardTank.ofCapacity(0)));
        this.module.getTank().changeCallback(this::tankChanged);
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.fluidHandler.ifPresent(fluidHandler -> {
            Collection<IFluidHandler> neighbors = FluidTools.findNeighbors(this.m_58904_(), this.m_58899_(), blockEntity -> {
                TankBlockEntity tank;
                return !(blockEntity instanceof TankBlockEntity) || !(tank = (TankBlockEntity)blockEntity).getMembership().equals(this.getMembership());
            }, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
            for (IFluidHandler neighbor : neighbors) {
                FluidUtil.tryFluidTransfer((IFluidHandler)neighbor, (IFluidHandler)fluidHandler, (int)1000, (boolean)true);
            }
        });
    }

    private void lightChanged(int light) {
        if (this.m_58900_().m_60734_() instanceof TankGaugeBlock) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)TankGaugeBlock.LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    protected void tankChanged() {
        if (!this.m_58898_() || this.f_58857_.m_5776_()) {
            return;
        }
        this.m_6596_();
        this.syncToClient();
        FluidStack fluidStack = this.module.getTank().getFluid();
        FluidType fluidType = this.module.getTank().getFluidType().getFluidType();
        int light = fluidType.getLightLevel(fluidStack);
        if (light != this.lastLight) {
            this.lastLight = light;
            this.streamMembers().forEach(member -> member.lightChanged(light));
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TankMenu(id, inventory, this);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)Translations.Container.TANK);
    }

    public TankModule getModule() {
        return this.module;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @Override
    public InteractionResult use(ServerPlayer player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.module.getTank()) ? InteractionResult.CONSUME : super.use(player, hand);
    }

    protected abstract int getCapacityPerBlock();

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return element.marker() == 'W' || element.marker() == 'B';
    }

    @Override
    public boolean isStillValid(Player player) {
        return TankBlockEntity.isStillValid(this, player, 256);
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<TankBlockEntity> membership) {
        this.getCurrentPattern().ifPresent(pattern -> {
            this.module.getTank().setCapacity(this.getCapacityPerBlock() * pattern.getArea());
            this.maxX = pattern.getXSize();
            this.maxY = pattern.getYSize();
            this.maxZ = pattern.getZSize();
            this.syncToClient();
        });
        if (membership == null) {
            this.getModule().getTank().setFluid(FluidStack.EMPTY);
            this.lightChanged(0);
            this.fluidHandler = LazyOptional.empty();
        } else if (this.m_58900_().m_60734_() instanceof TankValveBlock) {
            this.fluidHandler = LazyOptional.of(() -> new ValveFluidHandler(this, (TankBlockEntity)membership.master()));
        }
        Block block = this.m_58900_().m_60734_();
        if (block instanceof TankGaugeBlock) {
            AbstractStrengthenedGlassBlock.Type type;
            TankGaugeBlock block2 = (TankGaugeBlock)block;
            AbstractStrengthenedGlassBlock.Type type2 = type = membership == null ? AbstractStrengthenedGlassBlock.Type.SINGLE : AbstractStrengthenedGlassBlock.Type.determine(this.m_58899_(), this.f_58857_, (Block)block2);
            if (this.m_58900_().m_61143_(AbstractStrengthenedGlassBlock.TYPE) != type) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(AbstractStrengthenedGlassBlock.TYPE, (Comparable)((Object)type)));
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130130_(this.maxX);
        out.m_130130_(this.maxY);
        out.m_130130_(this.maxZ);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.maxX = in.m_130242_();
        this.maxY = in.m_130242_();
        this.maxZ = in.m_130242_();
    }

    protected static Collection<MultiblockPattern<Void>> buildPatterns(TagKey<Block> wallBlock, TagKey<Block> gaugeBlock, TagKey<Block> valveBlock) {
        List<List<CharList>> map;
        AABB entityCheck;
        int i;
        BlockPredicate wallPredicate = BlockPredicate.ofTag(wallBlock);
        BlockPredicate wallGaugeValvePredicate = wallPredicate.or(BlockPredicate.ofTag(gaugeBlock)).or(BlockPredicate.ofTag(valveBlock));
        ImmutableList.Builder patterns = ImmutableList.builder();
        List<CharList> bottom = List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'W', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'));
        List<CharList> middle = List.of(CharList.of((char)'B', (char)'W', (char)'B'), CharList.of((char)'W', (char)'A', (char)'W'), CharList.of((char)'B', (char)'W', (char)'B'));
        List<CharList> top = List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'W', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'));
        for (i = 4; i <= 8; ++i) {
            List<List<CharList>> pattern = TankBlockEntity.createTank(i, bottom, middle, top);
            entityCheck = new AABB(0.0, 1.0, 0.0, 1.0, (double)(i - 1), 1.0);
            patterns.add(TankBlockEntity.buildPattern(pattern, wallPredicate, wallGaugeValvePredicate, entityCheck));
        }
        if ((Integer)RailcraftConfig.SERVER.maxTankSize.get() >= 5) {
            bottom = List.of(CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B'}));
            middle = List.of(CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}));
            top = List.of(CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B'}));
            for (i = 4; i <= 8; ++i) {
                map = TankBlockEntity.createTank(i, bottom, middle, top);
                entityCheck = new AABB(-1.0, 1.0, -1.0, 2.0, (double)(i - 1), 2.0);
                patterns.add(TankBlockEntity.buildPattern(map, wallPredicate, wallGaugeValvePredicate, entityCheck));
            }
        }
        if ((Integer)RailcraftConfig.SERVER.maxTankSize.get() >= 7) {
            bottom = List.of(CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B'}));
            middle = List.of(CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}));
            top = List.of(CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B'}));
            for (i = 4; i <= 8; ++i) {
                map = TankBlockEntity.createTank(i, bottom, middle, top);
                entityCheck = new AABB(-2.0, 1.0, -2.0, 3.0, (double)(i - 1), 3.0);
                patterns.add(TankBlockEntity.buildPattern(map, wallPredicate, wallGaugeValvePredicate, entityCheck));
            }
        }
        if ((Integer)RailcraftConfig.SERVER.maxTankSize.get() >= 9) {
            bottom = List.of(CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'}));
            middle = List.of(CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}));
            top = List.of(CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B'}), CharList.of((char[])new char[]{'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'}));
            for (i = 4; i <= 8; ++i) {
                map = TankBlockEntity.createTank(i, bottom, middle, top);
                entityCheck = new AABB(-3.0, 1.0, -3.0, 4.0, (double)(i - 1), 4.0);
                patterns.add(TankBlockEntity.buildPattern(map, wallPredicate, wallGaugeValvePredicate, entityCheck));
            }
        }
        return patterns.build();
    }

    private static MultiblockPattern<Void> buildPattern(Collection<List<CharList>> pattern, BlockPredicate wallPredicate, BlockPredicate wallGaugeValvePredicate, AABB entityCheckBounds) {
        return MultiblockPattern.builder(1, 0, 1).pattern(pattern).entityCheckBounds(entityCheckBounds).predicate('B', wallPredicate).predicate('W', wallGaugeValvePredicate).predicate('A', BlockPredicate.AIR).build();
    }

    private static List<List<CharList>> createTank(int height, List<CharList> bottom, List<CharList> middle, List<CharList> top) {
        ArrayList<List<CharList>> pattern = new ArrayList<List<CharList>>(height);
        pattern.add(top);
        for (int i = 0; i < height - 2; ++i) {
            pattern.add(middle);
        }
        pattern.add(bottom);
        return pattern;
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    @FunctionalInterface
    public static interface LightCallback {
        public void lightChanged(BlockState var1, Level var2, BlockPos var3, int var4);
    }
}

