/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.Objects;
import java.util.UUID;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalController;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.TokenSignalEntity;
import mods.railcraft.api.signal.TrackLocator;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.TimerBag;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.ActionSignalBoxBlockEntity;
import mods.railcraft.world.signal.SimpleTokenRing;
import mods.railcraft.world.signal.TokenRingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TokenSignalBoxBlockEntity
extends ActionSignalBoxBlockEntity
implements TokenSignalEntity,
SignalControllerEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, false);
    private UUID ringId = UUID.randomUUID();
    private Vec3 ringCentroidPos;
    private final TimerBag<UUID> cartTimers = new TimerBag(8);
    private final TrackLocator trackLocator;

    public TokenSignalBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TOKEN_SIGNAL_BOX.get(), blockPos, blockState);
        this.trackLocator = new TrackLocator(() -> ((TokenSignalBoxBlockEntity)this).m_58904_(), blockPos);
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        this.signalController.destroy();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.signalController.refresh();
    }

    private void signalAspectChanged(SignalAspect signalAspect) {
        this.signalController.setSignalAspect(signalAspect);
        this.updateNeighborSignalBoxes(false);
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
    }

    @Override
    public int getRedstoneSignal(Direction side) {
        return this.isActionSignalAspect(this.signalNetwork().aspect()) ? 15 : 0;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("tokenRingId", this.ringId);
        tag.m_128365_("signalController", (Tag)this.signalController.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ringId = tag.m_128342_("tokenRingId");
        this.signalController.deserializeNBT(tag.m_128469_("signalController"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalController.writeToBuf(data);
        data.m_236821_((Object)this.ringCentroidPos, (buf, vec3) -> {
            buf.writeDouble(vec3.m_7096_());
            buf.writeDouble(vec3.m_7098_());
            buf.writeDouble(vec3.m_7094_());
        });
        data.m_130077_(this.ringId);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalController.readFromBuf(data);
        this.ringCentroidPos = (Vec3)data.m_236868_(buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        this.ringId = data.m_130259_();
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.signalController.aspect();
    }

    @Override
    public SignalController getSignalController() {
        return this.signalController;
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TokenSignalBoxBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TokenSignalBoxBlockEntity blockEntity) {
        BlockPos trackPos;
        SimpleTokenRing tokenRing = blockEntity.signalNetwork();
        if (!Objects.equals(blockEntity.ringCentroidPos, tokenRing.getCentroid())) {
            blockEntity.ringCentroidPos = tokenRing.getCentroid();
            blockEntity.syncToClient();
        }
        blockEntity.cartTimers.tick();
        if (blockEntity.trackLocator.trackStatus() == TrackLocator.Status.VALID && (trackPos = blockEntity.trackLocator.trackPos()) != null) {
            EntitySearcher.findMinecarts().at(trackPos).stream(level).filter(cart -> blockEntity.cartTimers.add(cart.m_20148_())).forEach(tokenRing::markCart);
        }
        if (blockEntity.signalController.aspect() != tokenRing.aspect()) {
            blockEntity.signalController.setSignalAspect(tokenRing.aspect());
            blockEntity.updateNeighborSignalBoxes(false);
        }
    }

    @Override
    public UUID ringId() {
        return this.ringId;
    }

    @Override
    public void setRingId(UUID tokenRingId) {
        this.ringId = tokenRingId;
    }

    @Override
    public Vec3 ringCentroidPos() {
        if (this.ringCentroidPos == null) {
            return this.m_58899_().m_252807_();
        }
        return this.ringCentroidPos;
    }

    @Override
    public SimpleTokenRing signalNetwork() {
        if (this.f_58857_.m_5776_()) {
            throw new IllegalStateException("Token ring is not available on the client.");
        }
        return TokenRingManager.get((ServerLevel)this.f_58857_).getTokenRingNetwork(this.ringId, this.m_58899_());
    }

    @Override
    public TrackLocator trackLocator() {
        return this.trackLocator;
    }
}

