/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AnalogSignalControllerBoxBlockEntity
extends AbstractSignalBoxBlockEntity
implements SignalControllerEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, true);
    private int inputSignal;
    private SignalAspect calculatedSignalAspect;
    private final Map<SignalAspect, BitSet> signalAspectTriggerSignals = new EnumMap<SignalAspect, BitSet>(SignalAspect.class);

    public AnalogSignalControllerBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ANALOG_SIGNAL_CONTROLLER_BOX.get(), blockPos, blockState);
        for (SignalAspect signalAspect : SignalAspect.values()) {
            this.signalAspectTriggerSignals.put(signalAspect, new BitSet());
        }
    }

    public Map<SignalAspect, BitSet> getSignalAspectTriggerSignals() {
        return this.signalAspectTriggerSignals;
    }

    public void setSignalAspectTriggerSignals(Map<SignalAspect, BitSet> signalAspectTriggerSignals) {
        this.signalAspectTriggerSignals.putAll(signalAspectTriggerSignals);
        this.m_6596_();
        this.updateSignalAspect();
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        this.signalController.destroy();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_()) {
            this.updateSignalAspect();
            this.signalController.refresh();
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, AnalogSignalControllerBoxBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }

    @Override
    public void neighborChanged() {
        int inputSignal = this.calculateInputSignal();
        if (inputSignal != this.inputSignal) {
            this.inputSignal = inputSignal;
            this.updateSignalAspect();
        }
    }

    private void updateSignalAspect() {
        this.calculatedSignalAspect = SignalAspect.OFF;
        for (Map.Entry<SignalAspect, BitSet> entry : this.signalAspectTriggerSignals.entrySet()) {
            SignalAspect current = entry.getKey();
            if (!entry.getValue().get(this.inputSignal)) continue;
            this.calculatedSignalAspect = this.calculatedSignalAspect == SignalAspect.OFF ? current : SignalAspect.mostRestrictive(this.calculatedSignalAspect, current);
        }
        this.signalController.setSignalAspect(this.calculatedSignalAspect);
    }

    private int calculateInputSignal() {
        int signal = 0;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction)) instanceof AbstractSignalBoxBlockEntity) continue;
            int tmp = this.f_58857_.m_277185_(this.m_58899_().m_121945_(direction), direction);
            if (tmp > signal) {
                signal = tmp;
            }
            if ((tmp = this.f_58857_.m_277185_(this.m_58899_().m_121945_(direction).m_7495_(), direction)) <= signal) continue;
            signal = tmp;
        }
        return signal;
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.signalController.aspect();
    }

    @Override
    public SimpleSignalController getSignalController() {
        return this.signalController;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("inputSignal", this.inputSignal);
        ListTag aspectsTag = new ListTag();
        for (Map.Entry<SignalAspect, BitSet> entry : this.signalAspectTriggerSignals.entrySet()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("name", entry.getKey().m_7912_());
            nbt.m_128382_("signals", entry.getValue().toByteArray());
            aspectsTag.add((Object)nbt);
        }
        tag.m_128365_("signalAspectTriggerSignals", (Tag)aspectsTag);
        tag.m_128365_("signalController", (Tag)this.signalController.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputSignal = tag.m_128451_("inputSignal");
        ListTag aspectsTag = tag.m_128437_("signalAspectTriggerSignals", 10);
        for (Tag nbt : aspectsTag) {
            CompoundTag compoundNbt = (CompoundTag)nbt;
            this.signalAspectTriggerSignals.put(SignalAspect.fromName(compoundNbt.m_128461_("name")).get(), BitSet.valueOf(compoundNbt.m_128463_("signals")));
        }
        this.signalController.deserializeNBT(tag.m_128469_("signalController"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalController.writeToBuf(data);
        data.m_236831_(this.signalAspectTriggerSignals, FriendlyByteBuf::m_130068_, FriendlyByteBuf::m_178350_);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalController.readFromBuf(data);
        this.signalAspectTriggerSignals.clear();
        this.signalAspectTriggerSignals.putAll(data.m_236847_(buf -> (SignalAspect)buf.m_130066_(SignalAspect.class), FriendlyByteBuf::m_178384_));
    }
}

