/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrainDetectorBlockEntity
extends DetectorBlockEntity {
    private int trainSize = 5;

    public TrainDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DETECTOR.get(), blockPos, blockState);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        if (minecarts.stream().mapToInt(cart -> RollingStock.getOrThrow(cart).train().size()).anyMatch(count -> count >= this.getTrainSize())) {
            return 15;
        }
        return 0;
    }

    @Override
    protected int updateInterval() {
        return 4;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.trainSize = tag.m_128451_("trainSize");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("trainSize", this.trainSize);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130130_(this.trainSize);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.trainSize = in.m_130242_();
    }

    public int getTrainSize() {
        return this.trainSize;
    }

    public void setTrainSize(int trainSize) {
        this.trainSize = trainSize;
    }
}

