/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.Optional;
import java.util.function.Function;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.track.LockingTrack;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ForceTrackEmitterState implements StringRepresentable
{
    EXTENDED("extended", true, emitter -> new Instance(){
        private int ticks;

        @Override
        public Optional<ForceTrackEmitterState> charged(Charge.Access access) {
            return this.ticks++ >= 64 ? Optional.of(EXTENDING) : Optional.empty();
        }

        @Override
        public ForceTrackEmitterState state() {
            return EXTENDED;
        }
    }){

        @Override
        public Instance load(ForceTrackEmitterBlockEntity emitter) {
            BlockState blockState;
            Block block;
            BlockPos pos = emitter.m_58899_().m_7494_();
            if (emitter.m_58898_() && (block = (blockState = emitter.m_58904_().m_8055_(pos)).m_60734_()) instanceof LockingTrack) {
                LockingTrack lockingTrack = (LockingTrack)block;
                lockingTrack.releaseCart();
            }
            return super.load(emitter);
        }
    }
    ,
    RETRACTED("retracted", false, emitter -> new Instance(){

        @Override
        public Optional<ForceTrackEmitterState> uncharged() {
            return Optional.empty();
        }

        @Override
        public ForceTrackEmitterState state() {
            return RETRACTED;
        }
    }),
    EXTENDING("extending", true, emitter -> new Instance((ForceTrackEmitterBlockEntity)emitter){
        private int ticks;
        final /* synthetic */ ForceTrackEmitterBlockEntity val$emitter;
        {
            this.val$emitter = forceTrackEmitterBlockEntity;
        }

        @Override
        public Optional<ForceTrackEmitterState> charged(Charge.Access access) {
            if (!access.hasCapacity(ForceTrackEmitterBlockEntity.getRequiredEnergy(this.val$emitter.getTrackCount() + 1))) {
                return Optional.of(HALTED);
            }
            if (this.val$emitter.getTrackCount() >= 64) {
                return Optional.of(EXTENDED);
            }
            if (this.ticks++ >= 2) {
                RailShape direction;
                this.ticks = 0;
                Direction facing = (Direction)this.val$emitter.m_58900_().m_61143_((Property)ForceTrackEmitterBlock.FACING);
                BlockPos toPlace = this.val$emitter.m_58899_().m_7494_().m_5484_(facing, this.val$emitter.getTrackCount() + 1);
                if (!this.val$emitter.m_58904_().m_46749_(toPlace)) {
                    return Optional.of(HALTED);
                }
                BlockState blockState = this.val$emitter.m_58904_().m_8055_(toPlace);
                if (!this.val$emitter.placeTrack(toPlace, blockState, direction = TrackUtil.getAxisAlignedDirection(facing))) {
                    return Optional.of(EXTENDED);
                }
            }
            return Optional.empty();
        }

        @Override
        public ForceTrackEmitterState state() {
            return EXTENDING;
        }
    }),
    RETRACTING("retracting", false, emitter -> new Instance((ForceTrackEmitterBlockEntity)emitter){
        private int ticks;
        final /* synthetic */ ForceTrackEmitterBlockEntity val$emitter;
        {
            this.val$emitter = forceTrackEmitterBlockEntity;
        }

        @Override
        public Optional<ForceTrackEmitterState> uncharged() {
            if (this.val$emitter.getTrackCount() == 0) {
                return Optional.of(RETRACTED);
            }
            if (this.ticks++ >= 2) {
                this.ticks = 0;
                this.val$emitter.removeFirstTrack();
            }
            return Optional.empty();
        }

        @Override
        public ForceTrackEmitterState state() {
            return RETRACTING;
        }
    }),
    HALTED("halted", false, __ -> new Instance(){

        @Override
        public ForceTrackEmitterState state() {
            return HALTED;
        }
    });

    private static final int TICKS_PER_ACTION = 2;
    private static final int TICKS_PER_REFRESH = 64;
    private static final int MAX_TRACKS = 64;
    private static final StringRepresentable.EnumCodec<ForceTrackEmitterState> CODEC;
    private final String name;
    private final boolean visuallyPowered;
    private final Function<ForceTrackEmitterBlockEntity, Instance> factory;

    private ForceTrackEmitterState(String name, boolean visuallyPowered, Function<ForceTrackEmitterBlockEntity, Instance> factory) {
        this.name = name;
        this.visuallyPowered = visuallyPowered;
        this.factory = factory;
    }

    public boolean isVisuallyPowered() {
        return this.visuallyPowered;
    }

    public Instance load(ForceTrackEmitterBlockEntity emitter) {
        return this.factory.apply(emitter);
    }

    public String m_7912_() {
        return this.name;
    }

    public static Optional<ForceTrackEmitterState> fromName(String name) {
        return Optional.ofNullable((ForceTrackEmitterState)CODEC.m_216455_(name));
    }

    static {
        CODEC = StringRepresentable.m_216439_(ForceTrackEmitterState::values);
    }

    public static interface Instance {
        default public Optional<ForceTrackEmitterState> charged(Charge.Access access) {
            return Optional.of(EXTENDING);
        }

        default public Optional<ForceTrackEmitterState> uncharged() {
            return Optional.of(RETRACTING);
        }

        public ForceTrackEmitterState state();
    }
}

