/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import it.unimi.dsi.fastutil.chars.CharList;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.world.inventory.BlastFurnaceMenu;
import mods.railcraft.world.level.block.FurnaceMultiblockBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.module.BlastFurnaceModule;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceBlockEntity
extends MultiblockBlockEntity<BlastFurnaceBlockEntity, Void> {
    private static final MultiblockPattern<Void> PATTERN = (MultiblockPattern)Util.m_137537_(() -> {
        BlockPredicate bricks = BlockPredicate.of(RailcraftBlocks.BLAST_FURNACE_BRICKS);
        BlockPredicate lava = BlockPredicate.ofFluidTag((TagKey<Fluid>)FluidTags.f_13132_);
        List<CharList> middle = List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'A', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'));
        return MultiblockPattern.builder(2, 1, 2).layer(List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'))).layer(middle).layer(middle).layer(List.of(CharList.of((char)'B', (char)'W', (char)'B'), CharList.of((char)'W', (char)'B', (char)'W'), CharList.of((char)'B', (char)'W', (char)'B'))).predicate('B', bricks).predicate('W', bricks).predicate('A', lava.or(BlockPredicate.AIR)).build();
    });
    private final BlastFurnaceModule blastFurnaceModule;
    private int fuelMoveTicks;

    public BlastFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.BLAST_FURNACE.get(), blockPos, blockState, BlastFurnaceBlockEntity.class, PATTERN);
        this.blastFurnaceModule = this.moduleDispatcher.registerModule("blast_furnace", new BlastFurnaceModule(this));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlastFurnaceBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
        blockEntity.getMasterBlockEntity().ifPresent(master -> {
            boolean lit = master.blastFurnaceModule.isBurning();
            if (lit != (Boolean)blockState.m_61143_((Property)FurnaceMultiblockBlock.LIT)) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)FurnaceMultiblockBlock.LIT, (Comparable)Boolean.valueOf(lit)));
            }
            if (blockEntity.fuelMoveTicks++ >= 128) {
                blockEntity.fuelMoveTicks = 0;
                blockEntity.findAdjacentContainers().moveOneItemTo(master.getBlastFurnaceModule().getFuelContainer(), master.blastFurnaceModule::isFuel);
            }
        });
    }

    public BlastFurnaceModule getBlastFurnaceModule() {
        return this.blastFurnaceModule;
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return element.marker() == 'B' || element.marker() == 'W';
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<BlastFurnaceBlockEntity> membership) {
        if (membership == null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)((BlockState)this.m_58900_().m_61124_((Property)FurnaceMultiblockBlock.WINDOW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FurnaceMultiblockBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Container)this.blastFurnaceModule);
        } else {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)FurnaceMultiblockBlock.WINDOW, (Comparable)Boolean.valueOf(membership.patternElement().marker() == 'W')), 3);
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new BlastFurnaceMenu(id, inventory, this);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)Translations.Container.BLAST_FURNACE);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getMasterBlockEntity().map(BlastFurnaceBlockEntity::getBlastFurnaceModule).map(BlastFurnaceModule::getItemHandler).map(LazyOptional::cast).orElse(LazyOptional.empty());
        }
        return super.getCapability(cap, side);
    }
}

