/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.function.Function;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.emi.BlastFurnaceEmiRecipe;
import mods.railcraft.integrations.emi.CokeOvenEmiRecipe;
import mods.railcraft.integrations.emi.CrusherEmiRecipe;
import mods.railcraft.integrations.emi.RollingEmiRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class RailcraftEmiPlugin
implements EmiPlugin {
    private static final EmiStack MANUAL_ROLLING_MACHINE = EmiStack.of((ItemLike)((ItemLike)RailcraftBlocks.MANUAL_ROLLING_MACHINE.get()));
    public static final EmiRecipeCategory ROLLING_CATEGORY = new EmiRecipeCategory(RailcraftConstants.rl("rolling_category"), (EmiRenderable)MANUAL_ROLLING_MACHINE);
    private static final EmiStack CRUSHER = EmiStack.of((ItemLike)((ItemLike)RailcraftBlocks.CRUSHER.get()));
    public static final EmiRecipeCategory CRUSHING_CATEGORY = new EmiRecipeCategory(RailcraftConstants.rl("crushing_category"), (EmiRenderable)CRUSHER);
    private static final EmiStack COKE_OVEN = EmiStack.of((ItemLike)((ItemLike)RailcraftBlocks.COKE_OVEN_BRICKS.get()));
    public static final EmiRecipeCategory COKING_CATEGORY = new EmiRecipeCategory(RailcraftConstants.rl("coking_category"), (EmiRenderable)COKE_OVEN);
    private static final EmiStack BLAST_FURNACE = EmiStack.of((ItemLike)((ItemLike)RailcraftBlocks.BLAST_FURNACE_BRICKS.get()));
    public static final EmiRecipeCategory BLASTING_CATEGORY = new EmiRecipeCategory(RailcraftConstants.rl("blasting_category"), (EmiRenderable)BLAST_FURNACE);

    public void register(EmiRegistry registry) {
        registry.addCategory(ROLLING_CATEGORY);
        registry.addCategory(CRUSHING_CATEGORY);
        registry.addCategory(COKING_CATEGORY);
        registry.addCategory(BLASTING_CATEGORY);
        registry.addWorkstation(ROLLING_CATEGORY, (EmiIngredient)MANUAL_ROLLING_MACHINE);
        registry.addWorkstation(ROLLING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)RailcraftBlocks.POWERED_ROLLING_MACHINE.get())));
        registry.addWorkstation(CRUSHING_CATEGORY, (EmiIngredient)CRUSHER);
        registry.addWorkstation(COKING_CATEGORY, (EmiIngredient)COKE_OVEN);
        registry.addWorkstation(BLASTING_CATEGORY, (EmiIngredient)BLAST_FURNACE);
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)RailcraftBlocks.STEAM_OVEN.get())));
        this.registerRecipe(registry, (RecipeType)RailcraftRecipeTypes.ROLLING.get(), RollingEmiRecipe::new);
        this.registerRecipe(registry, (RecipeType)RailcraftRecipeTypes.CRUSHING.get(), CrusherEmiRecipe::new);
        this.registerRecipe(registry, (RecipeType)RailcraftRecipeTypes.COKING.get(), CokeOvenEmiRecipe::new);
        this.registerRecipe(registry, (RecipeType)RailcraftRecipeTypes.BLASTING.get(), BlastFurnaceEmiRecipe::new);
    }

    private <C extends Container, T extends Recipe<C>> void registerRecipe(EmiRegistry registry, RecipeType<T> recipeType, Function<T, EmiRecipe> emiRecipeFunction) {
        RecipeManager manager = registry.getRecipeManager();
        for (Recipe x : manager.m_44013_(recipeType)) {
            registry.addRecipe(emiRecipeFunction.apply(x));
        }
    }
}

