/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.worldgen.features;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class RailcraftOreFeatures {
    private static final int LEAD_VEIN_DIMENSION = 9;
    private static final int TIN_SMALL_VEIN_DIMENSION = 4;
    private static final int TIN_LARGE_VEIN_DIMENSION = 9;
    private static final int SULFUR_VEIN_DIMENSION = 10;
    private static final int ZINC_VEIN_DIMENSION = 6;
    private static final int NICKEL_VEIN_DIMENSION = 7;
    private static final int NICKEL_SMALL_VEIN_DIMENSION = 4;
    private static final int SILVER_VEIN_DIMENSION = 10;
    private static final int QUARRIED_STONE_VEIN_DIMENSION = 32;
    private static final TagMatchTest STONE_ORE_REPLACEABLES = new TagMatchTest(BlockTags.f_144266_);
    private static final TagMatchTest DEEPSLATE_ORE_REPLACEABLES = new TagMatchTest(BlockTags.f_144267_);
    private static final TagMatchTest BASE_STONE_OVERWORLD = new TagMatchTest(BlockTags.f_13061_);
    private static final Supplier<List<OreConfiguration.TargetBlockState>> LEAD_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.LEAD_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_LEAD_ORE.get()).m_49966_())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> TIN_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.TIN_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_TIN_ORE.get()).m_49966_())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> SULFUR_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.SULFUR_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_SULFUR_ORE.get()).m_49966_())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> ZINC_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.ZINC_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_ZINC_ORE.get()).m_49966_())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> NICKEL_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.NICKEL_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_NICKEL_ORE.get()).m_49966_())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> SILVER_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.SILVER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_SILVER_ORE.get()).m_49966_())));
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE = RailcraftOreFeatures.createKey("lead_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_SMALL = RailcraftOreFeatures.createKey("tin_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_LARGE = RailcraftOreFeatures.createKey("tin_ore_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE = RailcraftOreFeatures.createKey("sulfur_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE_BURIED = RailcraftOreFeatures.createKey("sulfur_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZINC_ORE = RailcraftOreFeatures.createKey("zinc_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NICKEL_ORE = RailcraftOreFeatures.createKey("nickel_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NICKEL_ORE_SMALL = RailcraftOreFeatures.createKey("nickel_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = RailcraftOreFeatures.createKey("silver_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE_BURIED = RailcraftOreFeatures.createKey("silver_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> QUARRIED_STONE = RailcraftOreFeatures.createKey("quarried_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SALTPETER = RailcraftOreFeatures.createKey("saltpeter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRESTONE = RailcraftOreFeatures.createKey("firestone");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        context.m_255272_(LEAD_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(LEAD_ORE_TARGET_LIST.get(), 9)));
        context.m_255272_(TIN_ORE_SMALL, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(TIN_ORE_TARGET_LIST.get(), 4)));
        context.m_255272_(TIN_ORE_LARGE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(TIN_ORE_TARGET_LIST.get(), 9)));
        context.m_255272_(SULFUR_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(SULFUR_ORE_TARGET_LIST.get(), 10)));
        context.m_255272_(SULFUR_ORE_BURIED, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(SULFUR_ORE_TARGET_LIST.get(), 10, 0.5f)));
        context.m_255272_(ZINC_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ZINC_ORE_TARGET_LIST.get(), 6)));
        context.m_255272_(NICKEL_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(NICKEL_ORE_TARGET_LIST.get(), 7)));
        context.m_255272_(NICKEL_ORE_SMALL, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(NICKEL_ORE_TARGET_LIST.get(), 4)));
        context.m_255272_(SILVER_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(SILVER_ORE_TARGET_LIST.get(), 10)));
        context.m_255272_(SILVER_ORE_BURIED, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(SILVER_ORE_TARGET_LIST.get(), 10, 0.5f)));
        context.m_255272_(QUARRIED_STONE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)BASE_STONE_OVERWORLD, ((Block)RailcraftBlocks.QUARRIED_STONE.get()).m_49966_(), 32)));
        context.m_255272_(SALTPETER, (Object)new ConfiguredFeature(Feature.f_65781_, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)((Block)RailcraftBlocks.SALTPETER_ORE.get())), BlockPredicate.m_198311_(List.of(Blocks.f_50493_, (Block)RailcraftBlocks.SALTPETER_ORE.get())), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 1)));
        context.m_255272_(FIRESTONE, (Object)new ConfiguredFeature(Feature.f_65781_, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)((Block)RailcraftBlocks.FIRESTONE_ORE.get())), BlockPredicate.m_198311_(List.of(Blocks.f_50134_, (Block)RailcraftBlocks.FIRESTONE_ORE.get())), (IntProvider)ConstantInt.m_146483_((int)1), 1)));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)RailcraftConstants.rl(name));
    }
}

