/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.CubeModel;
import mods.railcraft.client.model.LowSidesMinecartModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.renderer.entity.cart.ContentsMinecartRenderer;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.entity.vehicle.TankMinecart;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TankMinecartRenderer
extends ContentsMinecartRenderer<TankMinecart> {
    private static final ResourceLocation TANK_TEXTURE_LOCATION = RailcraftConstants.rl("textures/entity/minecart/tank.png");
    private final LowSidesMinecartModel<TankMinecart> bodyModel;
    private final LowSidesMinecartModel<TankMinecart> snowModel;
    private final CubeModel tankModel;

    public TankMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.bodyModel = new LowSidesMinecartModel(context.m_174023_(RailcraftModelLayers.LOW_SIDES_MINECART));
        this.snowModel = new LowSidesMinecartModel(context.m_174023_(RailcraftModelLayers.LOW_SIDES_MINECART_SNOW));
        this.tankModel = new CubeModel(RenderType::m_110470_, context.m_174023_(RailcraftModelLayers.CUBE));
    }

    @Override
    protected void renderContents(TankMinecart cart, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight, float red, float green, float blue, float alpha) {
        VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(this.tankModel.m_103119_(TANK_TEXTURE_LOCATION));
        this.tankModel.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
        this.renderTank(cart, partialTicks, poseStack, renderTypeBuffer, packedLight);
        if (cart.hasFilter()) {
            this.renderFilterItem(cart, poseStack, renderTypeBuffer, packedLight);
        }
    }

    private void renderTank(TankMinecart cart, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        StandardTank tank = cart.getTankManager();
        if (tank != null) {
            FluidStack fluidStack = tank.getFluid();
            float capacity = tank.getCapacity();
            if (capacity > 0.0f && fluidStack != null && fluidStack.getAmount() > 0) {
                poseStack.m_85836_();
                float level = (float)fluidStack.getAmount() / capacity;
                float fluidMaxY = fluidStack.getFluid().getFluidType().isLighterThanAir() ? 1.0f : Math.min(1.0f, level);
                CuboidModel fluidModel = FluidRenderer.getFluidModel(fluidStack, 0.9921875f, fluidMaxY - 0.0078125f, 0.9921875f, FluidRenderer.FluidType.STILL);
                poseStack.m_252880_(0.00390625f, 0.00390625f, 0.00390625f);
                if (fluidModel != null) {
                    fluidModel.setPackedLight(RenderUtil.calculateGlowLight(packedLight, fluidStack));
                    fluidModel.setPackedOverlay(OverlayTexture.f_118083_);
                    VertexConsumer builder = renderTypeBuffer.m_6299_(Sheets.m_110790_());
                    CuboidModelRenderer.render(fluidModel, poseStack, builder, RenderUtil.getColorARGB(fluidStack, level), CuboidModelRenderer.FaceDisplay.FRONT, true);
                }
                poseStack.m_85849_();
                if (cart.isFilling()) {
                    poseStack.m_85836_();
                    float size = 0.3f;
                    poseStack.m_252880_(0.35f, 0.0f, 0.35f);
                    CuboidModel fillingFluidModel = FluidRenderer.getFluidModel(fluidStack, 0.3f, 0.99609375f, 0.3f, FluidRenderer.FluidType.FLOWING);
                    if (fillingFluidModel != null) {
                        fillingFluidModel.setPackedLight(RenderUtil.calculateGlowLight(packedLight, fluidStack));
                        fillingFluidModel.setPackedOverlay(OverlayTexture.f_118083_);
                        VertexConsumer builder = renderTypeBuffer.m_6299_(Sheets.m_110790_());
                        CuboidModelRenderer.render(fillingFluidModel, poseStack, builder, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true);
                    }
                    poseStack.m_85849_();
                }
            }
        }
    }

    private void renderFilterItem(TankMinecart cart, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        matrixStack.m_85836_();
        ItemStack itemStack = cart.getFilterItem().m_41777_();
        float scale = 1.2f;
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, -0.9f, 0.68f);
        matrixStack.m_85841_(1.2f, 1.2f, 1.2f);
        Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, cart.m_9236_(), 0);
        matrixStack.m_85849_();
        matrixStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, -0.9f, 0.68f);
        matrixStack.m_85841_(1.2f, 1.2f, 1.2f);
        Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, cart.m_9236_(), 0);
        matrixStack.m_85849_();
    }

    @Override
    protected EntityModel<TankMinecart> getBodyModel(TankMinecart cart) {
        return this.bodyModel;
    }

    @Override
    protected EntityModel<TankMinecart> getSnowModel(TankMinecart cart) {
        return this.snowModel;
    }
}

