/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.detector;

import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetTankDetectorAttributesMessage;
import mods.railcraft.world.inventory.detector.TankDetectorMenu;
import mods.railcraft.world.level.block.entity.detector.TankDetectorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class TankDetectorScreen
extends RailcraftMenuScreen<TankDetectorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = RailcraftConstants.rl("textures/gui/container/tank_detector.png");
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final TankDetectorBlockEntity tankDetectorBlockEntity;
    private MultiButton<TankDetectorBlockEntity.Mode> mode;
    private int refreshTimer;

    public TankDetectorScreen(TankDetectorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97727_ = 140;
        this.f_97731_ = this.f_97727_ - 94;
        this.tankDetectorBlockEntity = ((TankDetectorMenu)this.f_97732_).getTankDetectorBlockEntity();
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return BACKGROUND_TEXTURE;
    }

    public void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        this.mode = (MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.LARGE_BUTTON, this.tankDetectorBlockEntity.getMode()).bounds(centreX + 95, centreY + 22, 60, 16)).stateCallback(this::setMode).build();
        this.m_142416_((GuiEventListener)this.mode);
    }

    private void setMode(TankDetectorBlockEntity.Mode mode) {
        if (mode != this.tankDetectorBlockEntity.getMode()) {
            this.tankDetectorBlockEntity.setMode(mode);
            NetworkChannel.GAME.sendToServer(new SetTankDetectorAttributesMessage(this.tankDetectorBlockEntity.m_58899_(), mode));
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.mode.setState(this.tankDetectorBlockEntity.getMode());
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)Translations.Screen.FILTER), 50, 29, 0x404040, false);
    }
}

