/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.client.gui.widget.button.ToggleButton;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetLocomotiveAttributesMessage;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.LocomotiveMenu;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.StringUtils;

public abstract class LocomotiveScreen<T extends LocomotiveMenu<?>>
extends RailcraftMenuScreen<T> {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final Locomotive locomotive;
    private final String type;
    private final Map<Locomotive.Mode, Button> modeButtons = new EnumMap<Locomotive.Mode, Button>(Locomotive.Mode.class);
    private final Map<Locomotive.Speed, Button> speedButtons = new EnumMap<Locomotive.Speed, Button>(Locomotive.Speed.class);
    private ToggleButton reverseButton;
    private MultiButton<Locomotive.Lock> lockButton;
    private int refreshTimer;

    protected LocomotiveScreen(T menu, Inventory inventory, Component title, String type) {
        super(menu, inventory, title);
        this.locomotive = ((LocomotiveMenu)((Object)menu)).getLocomotive();
        this.type = type;
        this.f_97727_ = 161;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private Optional<Tooltip> createLockTooltip(Locomotive.Lock lock) {
        return Optional.of(Tooltip.m_257550_((Component)(switch (lock) {
            default -> throw new IncompatibleClassChangeError();
            case Locomotive.Lock.LOCKED -> Component.m_237110_((String)Translations.Screen.LOCOMOTIVE_LOCK_LOCKED, (Object[])new Object[]{this.locomotive.getOwnerOrThrow().getName()});
            case Locomotive.Lock.UNLOCKED -> Component.m_237115_((String)Translations.Screen.LOCOMOTIVE_LOCK_UNLOCKED);
            case Locomotive.Lock.PRIVATE -> Component.m_237110_((String)Translations.Screen.LOCOMOTIVE_LOCK_PRIVATE, (Object[])new Object[]{this.locomotive.getOwnerOrThrow().getName()});
        })));
    }

    public void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        LinearLayout modeLayout = new LinearLayout(centreX + 4, centreY + this.getYSize() - 129, this.f_97726_ - 10, 16, LinearLayout.Orientation.HORIZONTAL);
        for (Locomotive.Mode mode : this.locomotive.getSupportedModes()) {
            MutableComponent tooltip = Component.m_237115_((String)Translations.makeKey("screen", String.format("locomotive.%s.mode.description.%s", this.type, mode.m_7912_())));
            RailcraftButton button = (RailcraftButton)this.m_142416_((GuiEventListener)((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(mode.getDisplayName(), __ -> this.setMode(mode), (TexturePosition)ButtonTexture.SMALL_BUTTON).size(54, 16)).tooltip(Tooltip.m_257550_((Component)tooltip))).build());
            modeLayout.m_264406_((LayoutElement)button);
            this.modeButtons.put(mode, button);
        }
        modeLayout.m_264036_();
        LinearLayout speedLayout = new LinearLayout(centreX + 4, centreY + this.getYSize() - 112, 105, 16, LinearLayout.Orientation.HORIZONTAL);
        this.reverseButton = (ToggleButton)this.m_142416_((GuiEventListener)((ToggleButton)((ToggleButton.Builder)ToggleButton.toggleBuilder((Component)Component.m_237113_((String)"R"), __ -> this.toggleReverse(), ButtonTexture.SMALL_BUTTON).size(12, 16)).toggled(this.locomotive.isReverse()).build()));
        speedLayout.m_264406_((LayoutElement)this.reverseButton);
        for (Locomotive.Speed speed : Locomotive.Speed.values()) {
            RailcraftButton button = (RailcraftButton)this.m_142416_((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder((Component)Component.m_237113_((String)StringUtils.repeat((char)'>', (int)speed.getLevel())), __ -> this.setSpeed(speed), (TexturePosition)ButtonTexture.SMALL_BUTTON).size(4 + speed.getLevel() * 6, 16)).build());
            button.f_93623_ = this.locomotive.getSpeed() == speed;
            speedLayout.m_264406_((LayoutElement)button);
            this.speedButtons.put(speed, button);
        }
        speedLayout.m_264036_();
        this.lockButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.locomotive.getLock()).bounds(centreX + 154, centreY + this.getYSize() - 111, 16, 16)).tooltipFactory(this::createLockTooltip).stateCallback(this::setLock).build()));
        this.updateButtons();
    }

    private void setMode(Locomotive.Mode mode) {
        if (this.locomotive.getMode() != mode) {
            this.locomotive.setMode(mode);
            this.sendAttributes();
        }
    }

    private void setSpeed(Locomotive.Speed speed) {
        if (this.locomotive.getSpeed() != speed) {
            this.locomotive.setSpeed(speed);
            this.sendAttributes();
        }
    }

    private void setLock(Locomotive.Lock lock) {
        if (this.locomotive.getLock() != lock) {
            this.locomotive.setLock(lock);
            this.locomotive.setOwner(lock == Locomotive.Lock.UNLOCKED ? null : this.f_96541_.m_91094_().m_92548_());
            this.sendAttributes();
        }
    }

    private void toggleReverse() {
        this.locomotive.setReverse(!this.locomotive.isReverse());
        this.sendAttributes();
    }

    protected void sendAttributes() {
        this.updateButtons();
        NetworkChannel.GAME.sendToServer(new SetLocomotiveAttributesMessage(this.locomotive.m_19879_(), this.locomotive.getMode(), this.locomotive.getSpeed(), this.locomotive.getLock(), this.locomotive.isReverse()));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.modeButtons.forEach((mode, button) -> {
            button.f_93623_ = this.locomotive.getMode() != mode && this.locomotive.isAllowedMode((Locomotive.Mode)((Object)mode));
        });
        this.speedButtons.forEach((speed, button) -> {
            button.f_93623_ = this.locomotive.getSpeed() != speed && (!this.locomotive.isReverse() || speed.getLevel() <= this.locomotive.getMaxReverseSpeed().getLevel());
        });
        this.reverseButton.setToggled(this.locomotive.isReverse());
        this.lockButton.f_93623_ = !this.locomotive.isLocked() || this.locomotive.getOwnerOrThrow().equals((Object)this.f_96541_.m_91094_().m_92548_());
        this.lockButton.setState(this.locomotive.getLock());
    }
}

