/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import java.util.Optional;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.util.EnumUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public enum SignalAspect implements StringRepresentable
{
    GREEN("green", 5),
    BLINK_YELLOW("blink_yellow", 3),
    YELLOW("yellow", 5),
    BLINK_RED("blink_red", 3),
    RED("red", 5),
    OFF("off", 0);

    private static final StringRepresentable.EnumCodec<SignalAspect> CODEC;
    private final String name;
    private final int blockLight;
    private final MutableComponent displayName;
    private static final int LAMP_LIGHT = 12;
    private static final int BLINK_DELAY_TICKS = 16;
    private static boolean blinkState;
    private static int blinkTimer;

    private SignalAspect(String name, int blockLight) {
        this.name = name;
        this.blockLight = blockLight;
        this.displayName = Component.m_237115_((String)RailcraftConstants.makeTranslationKey("signal", "aspect." + name));
    }

    public int getBlockLight() {
        return this.blockLight;
    }

    public MutableComponent getDisplayName() {
        return this.displayName;
    }

    public MutableComponent getDisplayNameWithColor() {
        ChatFormatting color = switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GREEN -> ChatFormatting.GREEN;
            case YELLOW, BLINK_YELLOW -> ChatFormatting.YELLOW;
            case BLINK_RED, RED, OFF -> ChatFormatting.RED;
        };
        return this.getDisplayName().m_6881_().m_130940_(color);
    }

    public String m_7912_() {
        return this.name;
    }

    public int getLampLight() {
        return this == OFF ? 0 : 12;
    }

    public boolean isBlinkAspect() {
        return this == BLINK_YELLOW || this == BLINK_RED;
    }

    public boolean isOffState() {
        return this == OFF || this.isBlinkAspect() && !SignalAspect.getBlinkState();
    }

    public SignalAspect getDisplayAspect() {
        if (this.isOffState()) {
            return OFF;
        }
        if (this == BLINK_YELLOW) {
            return YELLOW;
        }
        if (this == BLINK_RED) {
            return RED;
        }
        return this;
    }

    public SignalAspect next() {
        return (SignalAspect)EnumUtil.next((Enum)this, (Enum[])SignalAspect.values());
    }

    public SignalAspect previous() {
        return (SignalAspect)EnumUtil.previous((Enum)this, (Enum[])SignalAspect.values());
    }

    public int color() {
        return (switch (this) {
            case GREEN -> DyeColor.LIME;
            case YELLOW, BLINK_YELLOW -> DyeColor.YELLOW;
            default -> DyeColor.RED;
        }).m_41070_();
    }

    public static boolean getBlinkState() {
        return blinkState;
    }

    public static void tickBlinkState() {
        if (blinkTimer++ >= 16) {
            blinkTimer = 0;
            blinkState = !blinkState;
        }
    }

    public static SignalAspect mostRestrictive(@Nullable SignalAspect first, @Nullable SignalAspect second) {
        if (first == null && second == null) {
            return RED;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first.ordinal() > second.ordinal()) {
            return first;
        }
        return second;
    }

    public static Optional<SignalAspect> fromName(String name) {
        return Optional.ofNullable((SignalAspect)CODEC.m_216455_(name));
    }

    static {
        CODEC = StringRepresentable.m_216439_(SignalAspect::values);
    }
}

