/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import mods.railcraft.api.core.BlockEntityLike;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.api.signal.SignalNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSignalNetwork<T extends BlockEntityLike>
implements SignalNetwork<T>,
INBTSerializable<CompoundTag>,
NetworkSerializable {
    protected static final RandomSource RANDOM = RandomSource.m_216327_();
    private final Class<T> peerType;
    private final int maxPeers;
    private final Runnable syncListener;
    protected final Deque<BlockPos> peers = new ArrayDeque<BlockPos>();
    private final Collection<BlockPos> unmodifiablePeers = Collections.unmodifiableCollection(this.peers);
    private boolean linking;

    public AbstractSignalNetwork(Class<T> peerType, Runnable syncListener) {
        this(peerType, -1, syncListener);
    }

    public AbstractSignalNetwork(Class<T> peerType, int maxPeers, Runnable syncListener) {
        this.peerType = peerType;
        this.maxPeers = maxPeers;
        this.syncListener = syncListener;
    }

    public abstract Level getLevel();

    @Override
    public Optional<T> peerAt(BlockPos blockPos) {
        return this.peers.contains(blockPos) ? Optional.ofNullable(this.getBlockEntity(blockPos)) : Optional.empty();
    }

    @Nullable
    protected T getBlockEntity(BlockPos blockPos) {
        BlockEntity blockEntity = this.getLevel().m_7702_(blockPos);
        return (T)(this.peerType.isInstance(blockEntity) && !blockEntity.m_58901_() ? (BlockEntityLike)this.peerType.cast(blockEntity) : null);
    }

    @Override
    public Collection<BlockPos> peers() {
        return this.unmodifiablePeers;
    }

    @Override
    public boolean addPeer(T peer) {
        if (this.peers.contains(peer.asBlockEntity().m_58899_())) {
            return false;
        }
        BlockPos peerPos = peer.asBlockEntity().m_58899_();
        this.peers.add(peerPos);
        if (this.maxPeers > -1 && this.peers.size() > this.maxPeers) {
            this.removePeer(this.peers.peek());
        }
        this.syncToClient();
        return true;
    }

    @Override
    public void destroy() {
        ArrayList<BlockPos> peers = new ArrayList<BlockPos>(this.peers);
        for (BlockPos peerPos : peers) {
            this.removePeer(peerPos);
        }
    }

    @Override
    public void refresh() {
        this.peers.removeIf(peerPos -> this.peerAt((BlockPos)peerPos).filter(this::refreshPeer).isEmpty());
    }

    protected boolean refreshPeer(T peer) {
        return true;
    }

    @Override
    public boolean removePeer(BlockPos peerPos) {
        if (this.peers.remove(peerPos)) {
            this.syncToClient();
            return true;
        }
        return false;
    }

    @Override
    public boolean isLinking() {
        return this.linking;
    }

    @Override
    public void startLinking() {
        this.linking = true;
        this.syncToClient();
    }

    @Override
    public void stopLinking() {
        this.linking = false;
        this.syncToClient();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag peersTag = new ListTag();
        for (BlockPos peer : this.peers) {
            peersTag.add((Object)NbtUtils.m_129224_((BlockPos)peer));
        }
        tag.m_128365_("peers", (Tag)peersTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag peersTag = tag.m_128437_("peers", 10);
        for (Tag peerTag : peersTag) {
            this.peers.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)peerTag)));
        }
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        data.writeBoolean(this.linking);
        data.m_236828_(this.peers, FriendlyByteBuf::m_130064_);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        this.linking = data.readBoolean();
        this.peers.clear();
        this.peers.addAll(data.m_236845_(FriendlyByteBuf::m_130135_));
    }

    public void syncToClient() {
        this.syncListener.run();
    }
}

