/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.util.JsonUtil;
import mods.railcraft.util.LevelUtil;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SpikeMaulUseTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RailcraftConstants.rl("spike_maul_use");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        NbtPredicate tag = JsonUtil.getAsJsonObject(json, "nbt").map(NbtPredicate::m_57481_).orElse(NbtPredicate.f_57471_);
        ItemPredicate tool = JsonUtil.getAsJsonObject(json, "tool").map(ItemPredicate::m_45051_).orElse(ItemPredicate.f_45028_);
        LocationPredicate locationPredicate = JsonUtil.getAsJsonObject(json, "location").map(LocationPredicate::m_52629_).orElse(LocationPredicate.f_52592_);
        return new Instance(contextAwarePredicate, tag, tool, locationPredicate);
    }

    public void trigger(ServerPlayer player, ItemStack item, ServerLevel serverLevel, BlockPos pos) {
        this.m_66234_(player, criterionInstance -> criterionInstance.matches(item, serverLevel, pos));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final NbtPredicate nbt;
        private final ItemPredicate tool;
        private final LocationPredicate location;

        private Instance(ContextAwarePredicate contextAwarePredicate, NbtPredicate nbt, ItemPredicate tool, LocationPredicate predicate) {
            super(ID, contextAwarePredicate);
            this.nbt = nbt;
            this.tool = tool;
            this.location = predicate;
        }

        public static Instance hasUsedSpikeMaul() {
            return new Instance(ContextAwarePredicate.f_285567_, NbtPredicate.f_57471_, ItemPredicate.f_45028_, LocationPredicate.f_52592_);
        }

        public boolean matches(ItemStack item, ServerLevel level, BlockPos pos) {
            return LevelUtil.getBlockEntity((Level)level, pos).map(BlockEntity::m_187482_).map(arg_0 -> ((NbtPredicate)this.nbt).m_57483_(arg_0)).orElse(false) != false && this.tool.m_45049_(item) && this.location.m_52617_(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = new JsonObject();
            json.add("nbt", this.nbt.m_57476_());
            json.add("tool", this.tool.m_45048_());
            json.add("location", this.location.m_52616_());
            return json;
        }
    }
}

