/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.AxisCycle;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UVTransformation;
import codechicken.lib.vec.uv.UVTranslation;
import codechicken.microblock.util.MaskedCuboid;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mrtjp.projectred.transmission.client.FramedJacketedWireModel;
import mrtjp.projectred.transmission.client.FramedWireModelBuilder;
import mrtjp.projectred.transmission.client.WireModelBuilder;
import mrtjp.projectred.transmission.part.BaseCenterWirePart;

public class FramedJacketedWireModelBuilder {
    private int connMap = 0;
    private int tw = 0;
    private double w = 0.0;
    private int connCount = 0;
    private int axisCount = 0;
    private final int[] fRotationMasks = new int[6];
    private final int[] fAxisCounts = new int[6];
    private int i = 0;
    @Nullable
    private FramedJacketedWireModel model;
    private int modelKey = 0;
    private boolean modelBuilt = false;

    public FramedJacketedWireModelBuilder setModelKey(int key) {
        this.modelKey = key;
        return this;
    }

    public FramedJacketedWireModel build() {
        if (!this.modelBuilt) {
            this.buildModel();
            this.modelBuilt = true;
            assert (this.model != null);
            return this.model;
        }
        assert (this.model != null);
        return this.model.copy();
    }

    private void buildModel() {
        this.connMap = this.modelKey & 0x3F;
        this.connCount = FramedWireModelBuilder.countConnections(this.connMap);
        this.axisCount = FramedWireModelBuilder.countAxis(this.connMap);
        for (int s = 0; s < 6; ++s) {
            this.fRotationMasks[s] = FramedWireModelBuilder.calcFaceRotationMask(this.connMap, s);
            this.fAxisCounts[s] = FramedWireModelBuilder.countFaceAxis(this.fRotationMasks[s]);
        }
        int thickness = this.modelKey >> 6;
        this.tw = thickness + 1;
        this.w = (double)this.tw / 16.0 + 0.004;
        this.i = 0;
        CCModel ccModel = this.generateJacketedWireModel();
        MaskedCuboid[] jacketedBoxes = this.generateJacketedBoxes();
        MaskedCuboid[] highlightBoxes = this.generateHighlightBoxes();
        this.model = new FramedJacketedWireModel(ccModel, jacketedBoxes, highlightBoxes);
    }

    private CCModel generateJacketedWireModel() {
        int n = this.connCount == 0 ? 6 : (this.connCount == 1 ? 2 : this.connCount);
        CCModel model = CCModel.quadModel((int)(n * 4));
        for (int s = 0; s < 6; ++s) {
            this.generateJacketedSide(model, s);
        }
        WireModelBuilder.finishModel(model);
        return model;
    }

    private void generateJacketedSide(CCModel model, int s) {
        double d;
        double d2 = (this.connMap & 1 << s) != 0 ? 0.0 : (this.connCount == 0 ? 0.25 : (d = this.connCount == 1 && (this.connMap & 1 << (s ^ 1)) != 0 ? 0.25 : -1.0));
        if (d == -1.0) {
            return;
        }
        Vertex5[] verts = this.faceVerts(s, d - 0.002);
        Transformation t = AxisCycle.cycles[s / 2].at(Vector3.CENTER);
        UVTranslation uvt = new UVTranslation(12.0, 12.0);
        for (Vertex5 v : verts) {
            v.apply(t);
            v.apply((UVTransformation)uvt);
        }
        this.i = WireModelBuilder.addVerts(model, verts, this.i);
    }

    private Vertex5[] faceVerts(int s, double d) {
        Vertex5[] verts = new Vertex5[]{new Vertex5(0.5 - this.w, d, 0.5 - this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, d, 0.5 - this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, d, 0.5 + this.w, (double)(8 + this.tw), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, d, 0.5 + this.w, (double)(8 - this.tw), (double)(16 - this.tw))};
        if (s % 2 == 1) {
            Transformation t = new Scale(1.0, -1.0, 1.0).at(Vector3.CENTER);
            WireModelBuilder.apply(t, verts);
            FramedJacketedWireModelBuilder.reverseOrder(verts);
        }
        return verts;
    }

    private MaskedCuboid[] generateJacketedBoxes() {
        if (this.connCount == 0) {
            return new MaskedCuboid[]{new MaskedCuboid(BaseCenterWirePart.fOBounds[6], 0)};
        }
        int n = 0;
        for (int a = 0; a < 3; ++a) {
            if ((this.connMap & 3 << a * 2) == 0) continue;
            ++n;
        }
        MaskedCuboid[] boxes = new MaskedCuboid[n];
        this.i = 0;
        boolean first = true;
        for (int a = 0; a < 3; ++a) {
            if (!this.generateAxialJacketedBoxes(a, first, boxes)) continue;
            first = false;
        }
        return boxes;
    }

    private MaskedCuboid[] generateHighlightBoxes() {
        if (this.connCount == 0) {
            return new MaskedCuboid[]{new MaskedCuboid(BaseCenterWirePart.fOBounds[6], 0)};
        }
        LinkedList<MaskedCuboid> boxes = new LinkedList<MaskedCuboid>();
        for (int s = 0; s < 6; ++s) {
            if ((this.connMap & 1 << s) == 0) continue;
            Cuboid6 box = BaseCenterWirePart.fOBounds[0].copy();
            box.apply(Rotation.sideRotations[s].at(Vector3.CENTER));
            int fMask = 1 << (s ^ 1);
            boxes.add(new MaskedCuboid(box, fMask));
        }
        boxes.add(new MaskedCuboid(BaseCenterWirePart.fOBounds[6], this.connMap));
        return boxes.toArray(new MaskedCuboid[0]);
    }

    private boolean generateAxialJacketedBoxes(int a, boolean first, MaskedCuboid[] boxes) {
        Cuboid6 box;
        int mask = this.connMap >> a * 2 & 3;
        if (mask == 0) {
            return false;
        }
        switch (mask) {
            case 1: {
                box = BaseCenterWirePart.fOBounds[0].copy();
                break;
            }
            case 2: {
                box = BaseCenterWirePart.fOBounds[1].copy();
                break;
            }
            default: {
                box = BaseCenterWirePart.fOBounds[0].copy();
                box.max.y = 1.0;
            }
        }
        box.apply(Rotation.sideRotations[a * 2].at(Vector3.CENTER));
        if (first) {
            box.enclose(BaseCenterWirePart.fOBounds[6]);
        }
        int fMask = first || mask == 3 ? 0 : (mask == 1 ? 1 << 2 * a + 1 : 1 << 2 * a);
        boxes[this.i++] = new MaskedCuboid(box, fMask);
        return true;
    }

    private static void reverseOrder(Vertex5[] verts) {
        for (int k = 0; k < verts.length; k += 4) {
            Vertex5 tmp = verts[k + 1];
            verts[k + 1] = verts[k + 3];
            verts[k + 3] = tmp;
        }
    }
}

