/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.sgjourney.Transporter;

public class TransporterConnection {
    private final UUID uuid;
    private final Transporter transporterA;
    private final Transporter transporterB;
    private final int timeOffsetA;
    private final int timeOffsetB;

    private TransporterConnection(MinecraftServer server, UUID uuid, Transporter transporterA, Transporter transporterB) {
        this.uuid = uuid;
        this.transporterA = transporterA;
        this.transporterB = transporterB;
        this.timeOffsetA = transporterA.getTimeOffset(server);
        this.timeOffsetB = transporterB.getTimeOffset(server);
    }

    @Nullable
    public static final TransporterConnection create(MinecraftServer server, Transporter transporterA, Transporter transporterB) {
        UUID uuid = UUID.randomUUID();
        if (transporterA != null && transporterB != null) {
            return new TransporterConnection(server, uuid, transporterA, transporterB);
        }
        return null;
    }

    public final void tick(MinecraftServer server) {
        if (!this.isTransporterValid(server, this.transporterA) || !this.isTransporterValid(server, this.transporterB)) {
            return;
        }
    }

    public final boolean isTransporterValid(MinecraftServer server, Transporter transporter) {
        if (transporter == null) {
            StargateJourney.LOGGER.error("Transporter does not exist");
            return false;
        }
        if (transporter.getTransporterEntity(server).isPresent()) {
            if (transporter.getTransporterEntity(server).get().isConnected()) {
                return true;
            }
            StargateJourney.LOGGER.info("Transporter is not connected");
        } else {
            StargateJourney.LOGGER.info("Transporter not found");
        }
        return false;
    }
}

