/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Wormhole;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public final class StargateConnection {
    private static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    private static final String EVENT_INCOMING_CONNECTION = "stargate_incoming_connection";
    private static final String EVENT_INCOMING_WORMHOLE = "stargate_incoming_wormhole";
    private static final String EVENT_OUTGOING_WORMHOLE = "stargate_outgoing_wormhole";
    private static final String EVENT_DISCONNECTED = "stargate_disconnected";
    private static final String ADDRESS = "address";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    private static final String DIALING_STARGATE = "DialingStargate";
    private static final String DIALED_STARGATE = "DialedStargate";
    private static final String USED = "Used";
    private static final String TIME_SINCE_LAST_TRAVELER = "TimeSinceLastTraveler";
    private static final String OPEN_TIME = "OpenTime";
    private static final String CONNECTION_TIME = "ConnectionTime";
    private static final String CONNECTION_TYPE = "ConnectionType";
    private static final String DO_KAWOOSH = "DoKawoosh";
    public static final int KAWOOSH_TICKS = 40;
    public static final int VORTEX_TICKS = 20;
    protected static final int maxOpenTime = (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    protected static final boolean energyBypassEnabled = (Boolean)CommonStargateConfig.enable_energy_bypass.get();
    protected static final int energyBypassMultiplier = (Integer)CommonStargateConfig.energy_bypass_multiplier.get();
    protected static final boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    protected static final long systemWideConnectionCost = (Long)CommonStargateConfig.system_wide_connection_energy_cost.get();
    protected static final long interstellarConnectionCost = (Long)CommonStargateConfig.interstellar_connection_energy_cost.get();
    protected static final long intergalacticConnectionCost = (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    protected static final long systemWideConnectionDraw = (Long)CommonStargateConfig.system_wide_connection_energy_draw.get();
    protected static final long interstellarConnectionDraw = (Long)CommonStargateConfig.interstellar_connection_energy_draw.get();
    protected static final long intergalacticConnectionDraw = (Long)CommonStargateConfig.intergalactic_connection_energy_draw.get();
    protected final UUID uuid;
    protected final Type connectionType;
    protected Stargate dialingStargate;
    protected Stargate dialedStargate;
    protected boolean doKawoosh;
    protected boolean used;
    protected int openTime;
    protected int connectionTime;
    protected int timeSinceLastTraveler;

    private StargateConnection(UUID uuid, Type connectionType, Stargate dialingStargate, Stargate dialedStargate, boolean used, int openTime, int connectionTime, int timeSinceLastTraveler, boolean doKawoosh) {
        this.uuid = uuid;
        this.connectionType = connectionType;
        this.dialingStargate = dialingStargate;
        this.dialedStargate = dialedStargate;
        this.used = used;
        this.openTime = openTime;
        this.connectionTime = connectionTime;
        this.timeSinceLastTraveler = timeSinceLastTraveler;
        this.doKawoosh = doKawoosh;
    }

    public final void printConnection() {
        System.out.println("-[" + this.uuid + "]");
        System.out.println(" | From: " + this.dialingStargate.get9ChevronAddress().toString());
        System.out.println(" | To: " + this.dialedStargate.get9ChevronAddress().toString());
        System.out.println(" | Open Time: " + this.openTime);
        System.out.println(" | Connection Time: " + this.connectionTime);
    }

    public static final Type getType(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate) {
        SolarSystem.Serializable dialingSystem = Universe.get(server).getSolarSystemFromDimension(dialingStargate.getDimension());
        SolarSystem.Serializable dialedSystem = Universe.get(server).getSolarSystemFromDimension(dialedStargate.getDimension());
        if (dialingSystem != null && dialedSystem != null) {
            if (dialingSystem.equals(dialedSystem)) {
                return Type.SYSTEM_WIDE;
            }
            List dialingGalaxies = dialingSystem.getGalacticAddresses().entrySet().stream().toList();
            List dialedGalaxies = dialedSystem.getGalacticAddresses().entrySet().stream().toList();
            if (!dialingGalaxies.isEmpty() && !dialedGalaxies.isEmpty()) {
                for (int i = 0; i < dialingGalaxies.size(); ++i) {
                    for (int j = 0; j < dialedGalaxies.size(); ++j) {
                        Galaxy.Serializable dialedGalaxy;
                        Galaxy.Serializable dialingGalaxy = (Galaxy.Serializable)((Map.Entry)dialingGalaxies.get(i)).getKey();
                        if (!dialingGalaxy.equals(dialedGalaxy = (Galaxy.Serializable)((Map.Entry)dialedGalaxies.get(j)).getKey())) continue;
                        return Type.INTERSTELLAR;
                    }
                }
            }
        }
        return Type.INTERGALACTIC;
    }

    private StargateConnection(UUID uuid, Type connectionType, Stargate dialingStargate, Stargate dialedStargate, boolean doKawoosh) {
        this(uuid, connectionType, dialingStargate, dialedStargate, false, 0, 0, 0, doKawoosh);
    }

    public static final StargateConnection create(MinecraftServer server, Type connectionType, Stargate dialingStargate, Stargate dialedStargate, boolean doKawoosh) {
        UUID uuid = UUID.randomUUID();
        if (dialingStargate != null && dialedStargate != null) {
            dialedStargate.getStargateEntity(server).resetStargate(StargateInfo.Feedback.INTERRUPTED_BY_INCOMING_CONNECTION);
            dialingStargate.getStargateEntity(server).setKawooshTickCount(0);
            dialingStargate.getStargateEntity(server).updateClient();
            dialedStargate.getStargateEntity(server).setKawooshTickCount(0);
            dialedStargate.getStargateEntity(server).updateClient();
            dialingStargate.getStargateEntity(server).connectStargate(uuid, State.OUTGOING_CONNECTION);
            dialedStargate.getStargateEntity(server).connectStargate(uuid, State.INCOMING_CONNECTION);
            return new StargateConnection(uuid, connectionType, dialingStargate, dialedStargate, doKawoosh);
        }
        return null;
    }

    public final void terminate(MinecraftServer server, StargateInfo.Feedback feedback) {
        if (this.dialingStargate != null) {
            this.dialingStargate.getStargateEntity(server).updateInterfaceBlocks(EVENT_DISCONNECTED, feedback.getCode(), true);
            this.dialingStargate.resetStargate(server, feedback, true);
        }
        if (this.dialedStargate != null) {
            this.dialedStargate.getStargateEntity(server).updateInterfaceBlocks(EVENT_DISCONNECTED, feedback.getCode(), false);
            this.dialedStargate.resetStargate(server, feedback, true);
        }
        StargateNetwork.get(server).removeConnection(this.uuid, feedback);
    }

    public final boolean isStargateValid(MinecraftServer server, Stargate stargate) {
        if (stargate == null || stargate.getStargateEntity(server) == null) {
            StargateJourney.LOGGER.error("Stargate does not exist");
            return false;
        }
        BlockPos stargatePos = stargate.getBlockPos();
        Level stargateLevel = stargate.getStargateEntity(server).m_58904_();
        if (stargateLevel.m_7702_(stargatePos) instanceof AbstractStargateEntity) {
            if (stargate.isConnected(server)) {
                return true;
            }
            StargateJourney.LOGGER.info("Stargate is not connected");
            return false;
        }
        StargateJourney.LOGGER.info("Stargate not found");
        return false;
    }

    public final void tick(MinecraftServer server) {
        if (!this.isStargateValid(server, this.dialingStargate) || !this.isStargateValid(server, this.dialedStargate)) {
            this.terminate(server, StargateInfo.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
            return;
        }
        if (this.openTime == 0) {
            this.dialedStargate.getStargateEntity(server).updateInterfaceBlocks(EVENT_INCOMING_CONNECTION, new Object[0]);
        }
        StargateInfo.ChevronLockSpeed chevronLockSpeed = !this.doKawoosh() ? StargateInfo.ChevronLockSpeed.FAST : this.dialedStargate.getStargateEntity(server).getChevronLockSpeed();
        int chevronWaitTicks = chevronLockSpeed.getChevronWaitTicks();
        int kawooshStartTicks = chevronLockSpeed.getKawooshStartTicks();
        int maxKawooshTicks = kawooshStartTicks + 40;
        int maxOpenTicks = maxKawooshTicks + 20;
        this.increaseTicks(kawooshStartTicks, maxKawooshTicks, maxOpenTicks);
        int realOpenTime = this.openTime - kawooshStartTicks;
        if (this.openTime <= kawooshStartTicks) {
            if (this.doKawoosh()) {
                this.playStargateOpenSound(this.dialingStargate.getStargateEntity(server), kawooshStartTicks, this.openTime, false);
                this.playStargateOpenSound(this.dialedStargate.getStargateEntity(server), kawooshStartTicks, this.openTime, true);
            }
            int addressLength = this.dialingStargate.getStargateEntity(server).getAddress().getLength();
            Address dialingAddress = this.dialingStargate.getStargateEntity(server).getConnectionAddress(addressLength);
            this.dialedStargate.getStargateEntity(server).setEngagedChevrons(AbstractStargateEntity.getChevronConfiguration(addressLength));
            this.dialedStargate.getStargateEntity(server).doWhileDialed(this.openTime, chevronLockSpeed);
            if (this.openTime % chevronWaitTicks == 0) {
                int dialedAddressLength = this.dialedStargate.getStargateEntity(server).getAddress().getLength();
                if (dialedAddressLength < dialingAddress.getLength()) {
                    if (this.openTime / chevronWaitTicks == 4 && addressLength < 7) {
                        return;
                    }
                    if (this.openTime / chevronWaitTicks == 5 && addressLength < 8) {
                        return;
                    }
                    this.dialedStargate.getStargateEntity(server).encodeChevron(dialingAddress.getSymbol(dialedAddressLength), true, false);
                } else {
                    this.dialedStargate.getStargateEntity(server).chevronSound((short)0, true, false, false);
                    this.dialedStargate.getStargateEntity(server).updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.dialedStargate.getStargateEntity(server).getAddress().getLength() + 1, AbstractStargateEntity.getChevron(this.dialedStargate.getStargateEntity(server), this.dialedStargate.getStargateEntity(server).getAddress().getLength() + 1), true, 0);
                }
            }
            if (this.openTime == kawooshStartTicks) {
                List<Integer> emptyAddressList = Arrays.stream(new int[0]).boxed().toList();
                List<Integer> dialedAddressList = Arrays.stream(this.dialedStargate.getStargateEntity(server).getAddress().toArray()).boxed().toList();
                this.dialedStargate.getStargateEntity(server).updateBasicInterfaceBlocks(EVENT_INCOMING_WORMHOLE, emptyAddressList);
                this.dialedStargate.getStargateEntity(server).updateCrystalInterfaceBlocks(EVENT_INCOMING_WORMHOLE, emptyAddressList);
                this.dialedStargate.getStargateEntity(server).updateAdvancedCrystalInterfaceBlocks(EVENT_INCOMING_WORMHOLE, dialedAddressList);
                List<Integer> dialingAddressList = Arrays.stream(this.dialingStargate.getStargateEntity(server).getAddress().toArray()).boxed().toList();
                this.dialingStargate.getStargateEntity(server).updateInterfaceBlocks(EVENT_OUTGOING_WORMHOLE, dialingAddressList);
            }
            return;
        }
        if (this.openTime < maxOpenTicks) {
            this.dialingStargate.getStargateEntity(server).doKawoosh(realOpenTime);
            this.dialedStargate.getStargateEntity(server).doKawoosh(realOpenTime);
        } else {
            this.dialingStargate.getStargateEntity(server).setKawooshTickCount(realOpenTime);
            this.dialingStargate.getStargateEntity(server).updateClient();
            this.dialedStargate.getStargateEntity(server).setKawooshTickCount(realOpenTime);
            this.dialedStargate.getStargateEntity(server).updateClient();
        }
        if (this.doKawoosh() && this.openTime < maxKawooshTicks) {
            return;
        }
        this.dialingStargate.getStargateEntity(server).idleWormholeSound(false);
        this.dialedStargate.getStargateEntity(server).idleWormholeSound(true);
        if (this.connectionTime >= maxOpenTime && !energyBypassEnabled) {
            this.terminate(server, StargateInfo.Feedback.EXCEEDED_CONNECTION_TIME);
            return;
        }
        if (requireEnergy) {
            long energyDraw = this.connectionType.getPowerDraw();
            long l = energyDraw = this.connectionTime >= maxOpenTime ? energyDraw * (long)energyBypassMultiplier : energyDraw;
            if (!this.dialingStargate.canExtractEnergy(server, energyDraw) && !this.dialedStargate.canExtractEnergy(server, energyDraw)) {
                this.terminate(server, StargateInfo.Feedback.RAN_OUT_OF_POWER);
                return;
            }
            if (((Boolean)CommonStargateConfig.can_draw_power_from_both_ends.get()).booleanValue() && this.dialedStargate.getStargateEntity(server).getEnergyStored() > this.dialingStargate.getStargateEntity(server).getEnergyStored()) {
                this.dialedStargate.depleteEnergy(server, energyDraw, false);
            } else {
                this.dialingStargate.depleteEnergy(server, energyDraw, false);
            }
        }
        if (this.used) {
            ++this.timeSinceLastTraveler;
        }
        this.doWormhole(this.dialingStargate.getStargateEntity(server).getWormhole(), this.dialingStargate.getStargateEntity(server), this.dialedStargate.getStargateEntity(server), StargateInfo.WormholeTravel.ENABLED);
        this.doWormhole(this.dialedStargate.getStargateEntity(server).getWormhole(), this.dialedStargate.getStargateEntity(server), this.dialingStargate.getStargateEntity(server), (StargateInfo.WormholeTravel)((Object)CommonStargateConfig.two_way_wormholes.get()));
        if (this.dialingStargate.getStargateEntity(server).dhdInfo().autoclose() > 0 && this.timeSinceLastTraveler >= this.dialingStargate.getStargateEntity(server).dhdInfo().autoclose() * 20) {
            this.terminate(server, StargateInfo.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
        if (this.dialedStargate.getStargateEntity(server).dhdInfo().autoclose() > 0 && this.timeSinceLastTraveler >= this.dialedStargate.getStargateEntity(server).dhdInfo().autoclose() * 20) {
            this.terminate(server, StargateInfo.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
    }

    private final void playStargateOpenSound(AbstractStargateEntity stargate, int kawooshStartTicks, int ticks, boolean incoming) {
        if (ticks == kawooshStartTicks - stargate.getOpenSoundLead()) {
            stargate.openWormholeSound(incoming);
        }
    }

    private final void increaseTicks(int kawooshStartTicks, int maxKawooshTicks, int maxOpenTicks) {
        if (!this.doKawoosh() && this.openTime >= kawooshStartTicks && this.openTime < maxKawooshTicks) {
            this.openTime += 60;
        } else if (this.openTime < maxOpenTicks) {
            ++this.openTime;
        }
        if (this.openTime > maxKawooshTicks) {
            ++this.connectionTime;
        }
    }

    private final void doWormhole(Wormhole wormhole, AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, StargateInfo.WormholeTravel wormholeTravel) {
        IrisStargateEntity irisStargate;
        if (initialStargate instanceof IrisStargateEntity && (irisStargate = (IrisStargateEntity)initialStargate).irisInfo().isIrisClosed()) {
            return;
        }
        Vec3 stargatePos = initialStargate.getCenter();
        if (wormhole.findCandidates(initialStargate.m_58904_(), stargatePos, initialStargate.getDirection()) && this.used) {
            this.timeSinceLastTraveler = 0;
        }
        if (targetStargate.dhdInfo().shouldCallForward()) {
            if (wormhole.wormholeEntities(initialStargate, initialStargate, wormholeTravel)) {
                this.used = true;
            }
        } else if (wormhole.wormholeEntities(initialStargate, targetStargate, wormholeTravel)) {
            this.used = true;
        }
    }

    public void sendStargateMessage(MinecraftServer server, AbstractStargateEntity sendingStargate, String message) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            this.dialedStargate.getStargateEntity(server).receiveStargateMessage(message);
        } else {
            this.dialingStargate.getStargateEntity(server).receiveStargateMessage(message);
        }
    }

    public void sendStargateTransmission(MinecraftServer server, AbstractStargateEntity sendingStargate, int transmissionJumps, int frequency, String transmission) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            this.dialedStargate.getStargateEntity(server).forwardTransmission(transmissionJumps, frequency, transmission);
        } else {
            this.dialingStargate.getStargateEntity(server).forwardTransmission(transmissionJumps, frequency, transmission);
        }
    }

    public float checkStargateShieldingState(MinecraftServer server, AbstractStargateEntity sendingStargate) {
        float f;
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            float f2;
            AbstractStargateEntity abstractStargateEntity = this.dialedStargate.getStargateEntity(server);
            if (abstractStargateEntity instanceof IrisStargateEntity) {
                IrisStargateEntity irisStargate = (IrisStargateEntity)abstractStargateEntity;
                f2 = irisStargate.irisInfo().checkIrisState();
            } else {
                f2 = 0.0f;
            }
            return f2;
        }
        AbstractStargateEntity abstractStargateEntity = this.dialingStargate.getStargateEntity(server);
        if (abstractStargateEntity instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)abstractStargateEntity;
            f = irisStargate.irisInfo().checkIrisState();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public UUID getID() {
        return this.uuid;
    }

    public Type getConnectionType() {
        return this.connectionType;
    }

    @Nullable
    public Stargate getDialingStargate() {
        return this.dialingStargate;
    }

    @Nullable
    public Stargate getDialedStargate() {
        return this.dialedStargate;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public int getConnectionTime() {
        return this.connectionTime;
    }

    public int getTimeSinceLastTraveler() {
        return this.timeSinceLastTraveler;
    }

    public boolean doKawoosh() {
        return this.doKawoosh;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(DIALING_STARGATE, (Tag)this.serializeStargate(this.dialingStargate));
        tag.m_128365_(DIALED_STARGATE, (Tag)this.serializeStargate(this.dialedStargate));
        tag.m_128379_(USED, this.used);
        tag.m_128405_(OPEN_TIME, this.openTime);
        tag.m_128405_(CONNECTION_TIME, this.connectionTime);
        tag.m_128405_(TIME_SINCE_LAST_TRAVELER, this.timeSinceLastTraveler);
        tag.m_128359_(CONNECTION_TYPE, this.connectionType.toString().toUpperCase());
        tag.m_128379_(DO_KAWOOSH, this.doKawoosh);
        return tag;
    }

    protected CompoundTag serializeStargate(Stargate stargate) {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_(ADDRESS, stargate.get9ChevronAddress().toArray());
        tag.m_128359_(DIMENSION, stargate.getDimension().toString());
        tag.m_128385_(COORDINATES, new int[]{stargate.getBlockPos().m_123341_(), stargate.getBlockPos().m_123342_(), stargate.getBlockPos().m_123343_()});
        return tag;
    }

    @Nullable
    public static StargateConnection deserialize(MinecraftServer server, UUID uuid, CompoundTag tag) {
        Type connectionType = Type.valueOf(tag.m_128461_(CONNECTION_TYPE));
        Stargate dialingStargate = StargateConnection.deserializeStargate(server, tag.m_128469_(DIALING_STARGATE));
        Stargate dialedStargate = StargateConnection.deserializeStargate(server, tag.m_128469_(DIALED_STARGATE));
        boolean used = tag.m_128471_(USED);
        int openTime = tag.m_128451_(OPEN_TIME);
        int connectionTime = tag.m_128451_(CONNECTION_TIME);
        int timeSinceLastTraveler = tag.m_128451_(TIME_SINCE_LAST_TRAVELER);
        boolean doKawoosh = tag.m_128471_(DO_KAWOOSH);
        return new StargateConnection(uuid, connectionType, dialingStargate, dialedStargate, used, openTime, connectionTime, timeSinceLastTraveler, doKawoosh);
    }

    private static Stargate deserializeStargate(MinecraftServer server, CompoundTag stargateInfo) {
        return BlockEntityList.get(server).getStargate(new Address.Immutable(stargateInfo.m_128465_(ADDRESS)));
    }

    public static enum Type {
        SYSTEM_WIDE(systemWideConnectionCost, systemWideConnectionDraw),
        INTERSTELLAR(interstellarConnectionCost, interstellarConnectionDraw),
        INTERGALACTIC(intergalacticConnectionCost, intergalacticConnectionDraw);

        private long establishingPowerCost;
        private long powerDraw;

        private Type(long establishingPowerCost, long powerDraw) {
            this.establishingPowerCost = establishingPowerCost;
            this.powerDraw = powerDraw;
        }

        public long getEstablishingPowerCost() {
            return this.establishingPowerCost;
        }

        public long getPowerDraw() {
            return this.powerDraw;
        }
    }

    public static enum State {
        IDLE(0, false, false),
        OUTGOING_CONNECTION(1, true, true),
        INCOMING_CONNECTION(-1, true, false);

        private final byte value;
        private final boolean isConnected;
        private final boolean isDialingOut;

        private State(byte value, boolean isConnected, boolean isDialingOut) {
            this.value = value;
            this.isConnected = isConnected;
            this.isDialingOut = isDialingOut;
        }

        public byte byteValue() {
            return this.value;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public boolean isDialingOut() {
            return this.isDialingOut;
        }

        public static State fromByte(byte value) {
            return switch (value) {
                case 1 -> OUTGOING_CONNECTION;
                case -1 -> INCOMING_CONNECTION;
                default -> IDLE;
            };
        }
    }
}

