/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.init.GalaxyInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.GalaxyType;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class Galaxy {
    public static final ResourceKey<Registry<Galaxy>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("sgjourney", "galaxy"));
    public static final Codec<ResourceKey<Galaxy>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    public static final Codec<Galaxy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Galaxy::getName), (App)GalaxyInit.CODEC.fieldOf("type").forGetter(Galaxy::getType), (App)Symbols.RESOURCE_KEY_CODEC.fieldOf("default_symbols").forGetter(Galaxy::getDefaultSymbols)).apply((Applicative)instance, Galaxy::new));
    private final String name;
    private final GalaxyType type;
    private final ResourceKey<Symbols> defaultSymbols;

    public Galaxy(String name, GalaxyType type, ResourceKey<Symbols> defaultSymbols) {
        this.name = name;
        this.type = type;
        this.defaultSymbols = defaultSymbols;
    }

    public String getName() {
        return this.name;
    }

    public GalaxyType getType() {
        return this.type;
    }

    public ResourceKey<Symbols> getDefaultSymbols() {
        return this.defaultSymbols;
    }

    public static Galaxy getGalaxy(Level level, String part1, String part2) {
        return Galaxy.getGalaxy(level, new ResourceLocation(part1, part2));
    }

    public static Galaxy getGalaxy(Level level, ResourceLocation galaxy) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (Galaxy)registry.m_7745_(galaxy);
    }

    public static final class Serializable {
        public static final String SOLAR_SYSTEMS = "solar_systems";
        public static final String POINTS_OF_ORIGIN = "points_of_origin";
        private final ResourceKey<Galaxy> galaxyKey;
        private final Galaxy galaxy;
        private HashMap<Address.Immutable, SolarSystem.Serializable> solarSystems;
        private List<ResourceKey<PointOfOrigin>> pointsOfOrigin;

        public Serializable(ResourceKey<Galaxy> galaxyKey, Galaxy galaxy, HashMap<Address.Immutable, SolarSystem.Serializable> solarSystems, List<ResourceKey<PointOfOrigin>> pointsOfOrigin) {
            this.galaxyKey = galaxyKey;
            this.galaxy = galaxy;
            this.solarSystems = solarSystems;
            this.pointsOfOrigin = pointsOfOrigin;
            this.solarSystems.entrySet().stream().forEach(solarSystemEntry -> ((SolarSystem.Serializable)solarSystemEntry.getValue()).addToGalaxy(this, (Address.Immutable)solarSystemEntry.getKey()));
        }

        public ResourceKey<Galaxy> getKey() {
            return this.galaxyKey;
        }

        public Component getTranslationName() {
            return Component.m_237115_((String)this.galaxy.getName());
        }

        public ResourceKey<Symbols> getDefaultSymbols() {
            return this.galaxy.getDefaultSymbols();
        }

        public int getSize() {
            return this.galaxy.getType().getSize();
        }

        public void printSolarSystems() {
            this.solarSystems.entrySet().stream().forEach(solarSystemEntry -> System.out.println("--- " + ((Address.Immutable)solarSystemEntry.getKey()).toString() + " " + ((SolarSystem.Serializable)solarSystemEntry.getValue()).getName()));
        }

        public boolean containsSolarSystem(Address.Immutable address) {
            return this.solarSystems.containsKey(address);
        }

        @Nullable
        public SolarSystem.Serializable getSolarSystem(Address.Immutable address) {
            return this.solarSystems.get(address);
        }

        public void addSolarSystem(Address.Immutable address, SolarSystem.Serializable solarSystem) {
            this.solarSystems.put(address, solarSystem);
        }

        public void removeSolarSystem(Address.Immutable address) {
            if (this.containsSolarSystem(address)) {
                this.solarSystems.remove(address);
            }
        }

        @Nullable
        public SolarSystem.Serializable getRandomSolarSystem(long seed) {
            int size = this.solarSystems.size();
            if (size < 1) {
                return null;
            }
            Random random = new Random(seed);
            int randomValue = random.nextInt(0, size);
            SolarSystem.Serializable randomSolarSystem = (SolarSystem.Serializable)this.solarSystems.entrySet().stream().toArray()[randomValue];
            return randomSolarSystem;
        }

        public void addPointOfOrigin(ResourceKey<PointOfOrigin> pointOfOrigin) {
            if (!this.pointsOfOrigin.contains(pointOfOrigin)) {
                this.pointsOfOrigin.add(pointOfOrigin);
            }
        }

        public ResourceKey<PointOfOrigin> getRandomPointOfOrigin(long seed) {
            int size = this.pointsOfOrigin.size();
            if (size < 1) {
                return PointOfOrigin.defaultPointOfOrigin();
            }
            Random random = new Random(seed);
            int randomValue = random.nextInt(0, size);
            return this.pointsOfOrigin.get(randomValue);
        }

        public CompoundTag serialize() {
            CompoundTag galaxyTag = new CompoundTag();
            CompoundTag solarSystemsTag = new CompoundTag();
            this.solarSystems.entrySet().forEach(solarSystem -> solarSystemsTag.m_128385_(((Address.Immutable)solarSystem.getKey()).toString(), ((SolarSystem.Serializable)solarSystem.getValue()).getExtragalacticAddress().toArray()));
            galaxyTag.m_128365_(SOLAR_SYSTEMS, (Tag)solarSystemsTag);
            CompoundTag pointOfOriginTag = new CompoundTag();
            this.pointsOfOrigin.stream().forEach(pointOfOrigin -> {
                String pointOfOriginString = pointOfOrigin.m_135782_().toString();
                pointOfOriginTag.m_128359_(pointOfOriginString, pointOfOriginString);
            });
            galaxyTag.m_128365_(POINTS_OF_ORIGIN, (Tag)pointOfOriginTag);
            return galaxyTag;
        }

        public static Serializable deserialize(MinecraftServer server, HashMap<Address.Immutable, SolarSystem.Serializable> solarSystems, Registry<Galaxy> galaxyRegistry, ResourceKey<Galaxy> galaxyKey, CompoundTag galaxyTag) {
            Galaxy galaxy = (Galaxy)galaxyRegistry.m_6246_(galaxyKey);
            HashMap<Address.Immutable, SolarSystem.Serializable> galaxySolarSystems = new HashMap<Address.Immutable, SolarSystem.Serializable>();
            CompoundTag solarSystemsTag = galaxyTag.m_128469_(SOLAR_SYSTEMS);
            solarSystemsTag.m_128431_().forEach(addressString -> {
                Address.Immutable extragalacticAddress = new Address(solarSystemsTag.m_128465_(addressString)).immutable();
                Address.Immutable address = new Address((String)addressString).immutable();
                if (solarSystems.containsKey(extragalacticAddress)) {
                    SolarSystem.Serializable solarSystem = (SolarSystem.Serializable)solarSystems.get(extragalacticAddress);
                    galaxySolarSystems.put(address, solarSystem);
                }
            });
            CompoundTag pointOfOriginTag = galaxyTag.m_128469_(POINTS_OF_ORIGIN);
            ArrayList<ResourceKey<PointOfOrigin>> pointsOfOrigin = new ArrayList<ResourceKey<PointOfOrigin>>();
            pointOfOriginTag.m_128431_().forEach(pointOfOriginString -> pointsOfOrigin.add(Conversion.stringToPointOfOrigin(pointOfOriginString)));
            return new Serializable(galaxyKey, galaxy, galaxySolarSystems, pointsOfOrigin);
        }
    }
}

