/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.RingPanelEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ServerboundRingPanelUpdatePacket;

public class RingPanelMenu
extends AbstractContainerMenu {
    private final RingPanelEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 6;

    public RingPanelMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public RingPanelMenu(int containerId, Inventory inv, BlockEntity entity) {
        super((MenuType)MenuInit.RING_PANEL.get(), containerId);
        RingPanelMenu.m_38869_((Container)inv, (int)6);
        this.blockEntity = (RingPanelEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 5, 36));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 23, 36));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 5, 54));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 23, 54));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 5, 72));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 23, 72));
        });
    }

    public Component getRingsPos(int i) {
        if (i < this.blockEntity.ringsPos.size()) {
            BlockPos coords = this.blockEntity.ringsPos.get(i);
            Component name = this.blockEntity.ringsName.get(i);
            if (name.getString().length() == 0) {
                return Component.m_237113_((String)("[" + coords.m_123341_() + " " + coords.m_123342_() + " " + coords.m_123343_() + "]")).m_130940_(ChatFormatting.DARK_GREEN);
            }
            return Component.m_237119_().m_7220_(name).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)(" [" + coords.m_123341_() + " " + coords.m_123342_() + " " + coords.m_123343_() + "] ")).m_130940_(ChatFormatting.DARK_GREEN));
        }
        return Component.m_237113_((String)"-");
    }

    public void activateRings(int number) {
        PacketHandlerInit.INSTANCE.sendToServer((Object)new ServerboundRingPanelUpdatePacket(this.blockEntity.m_58899_(), number));
    }

    public int[] getTargetCoords(int chosenNumber) {
        return this.blockEntity.getTargetCoords(chosenNumber);
    }

    public boolean m_6875_(Player player) {
        return RingPanelMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.RING_PANEL.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 140 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 42, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 42) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }
}

