/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VialItem
extends Item {
    public static final int MAX_CAPACITY = 150;

    public VialItem(Item.Properties properties) {
        super(properties);
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new FluidHandlerItemStack(stack, 150){

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return stack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || stack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
            }
        };
    }

    public static ItemStack liquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.VIAL.get());
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(((FlowingFluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get()).m_5613_(), 150), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    public static ItemStack heavyLiquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.VIAL.get());
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(((FlowingFluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()).m_5613_(), 150), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    public static int getFluidAmount(ItemStack stack) {
        FluidStack fluidStack = VialItem.getFluidStack(stack);
        return fluidStack.getAmount();
    }

    public static int getNaquadahAmount(ItemStack stack) {
        FluidStack fluidStack = VialItem.getFluidStack(stack);
        if (fluidStack.getFluid() != FluidInit.LIQUID_NAQUADAH_SOURCE.get()) {
            return 0;
        }
        return fluidStack.getAmount();
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        Optional fluid = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> fluidHandler.getFluidInTank(0));
        return fluid.isPresent() ? (FluidStack)fluid.get() : FluidStack.EMPTY;
    }

    public static void drainNaquadah(ItemStack stack, int amount) {
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE));
    }

    public static int getMaxCapacity() {
        return 150;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        FluidStack fluidStack = VialItem.getFluidStack(stack);
        if (!VialItem.getFluidStack(stack).equals((Object)FluidStack.EMPTY)) {
            MutableComponent liquidNaquadah = Component.m_237115_((String)fluidStack.getTranslationKey()).m_130940_(ChatFormatting.GREEN);
            liquidNaquadah.m_7220_((Component)Component.m_237113_((String)(" " + fluidStack.getAmount() + "mB")).m_130940_(ChatFormatting.GREEN));
            tooltipComponents.add((Component)liquidNaquadah);
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

