/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.init.ItemInit;

public class NaquadahFuelRodItem
extends Item {
    public static final String FUEL = "Fuel";

    public NaquadahFuelRodItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack fuelRodSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.NAQUADAH_FUEL_ROD.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(FUEL, (long)((Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get()).intValue());
        return stack;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)NaquadahFuelRodItem.getFuel(stack) / (float)NaquadahFuelRodItem.getMaxFuel());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)NaquadahFuelRodItem.getFuel(stack) / (float)NaquadahFuelRodItem.getMaxFuel());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static int getFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(FUEL)) {
            tag.m_128405_(FUEL, NaquadahFuelRodItem.getMaxFuel());
        }
        int fuel = tag.m_128451_(FUEL);
        return fuel;
    }

    public static boolean depleteFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(FUEL)) {
            tag.m_128405_(FUEL, 0);
        }
        int fuel = tag.m_128451_(FUEL);
        tag.m_128405_(FUEL, --fuel);
        return fuel > 0;
    }

    public static int getMaxFuel() {
        return (Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (stack.m_41782_() && isAdvanced.m_7050_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.naquadah_fuel_rod.fuel").m_7220_((Component)Component.m_237113_((String)(": " + NaquadahFuelRodItem.getFuel(stack) + " / " + NaquadahFuelRodItem.getMaxFuel()))).m_130940_(ChatFormatting.GREEN));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static ItemStack randomFuelRod(int minCapacity, int maxCapacity) {
        ItemStack fusionCore = new ItemStack((ItemLike)ItemInit.NAQUADAH_FUEL_ROD.get());
        Random random = new Random();
        fusionCore.m_41784_().m_128405_(FUEL, random.nextInt(minCapacity, maxCapacity + 1));
        return fusionCore;
    }
}

